/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.codec.decoder;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Map;
import java.util.TreeMap;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderFactory;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.ConsumeToCrlfDecodingState;
import org.littleshoot.util.mina.ConsumeToTerminatorDecodingState;
import org.littleshoot.util.mina.CrlfDecodingState;
import org.littleshoot.util.mina.DecodingState;
import org.littleshoot.util.mina.DecodingStateMachine;
import org.littleshoot.util.mina.SpaceSkippingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SipHeaderDecodingState
extends DecodingStateMachine {
    private final Logger LOG = LoggerFactory.getLogger(SipHeaderDecodingState.class);
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    private final CharsetDecoder m_asciiDecoder = US_ASCII.newDecoder();
    private Map<String, SipHeader> m_headers = new TreeMap<String, SipHeader>();
    private final SipHeaderFactory m_headerFactory;

    public SipHeaderDecodingState(SipHeaderFactory headerFactory) {
        this.m_headerFactory = headerFactory;
    }

    protected DecodingState init() throws Exception {
        return new HeaderNameDecodingState();
    }

    protected void destroy() throws Exception {
    }

    private final class FindEmptyLine
    extends CrlfDecodingState {
        private FindEmptyLine() {
        }

        protected DecodingState finishDecode(boolean foundCrlf, ProtocolDecoderOutput out) throws Exception {
            if (foundCrlf) {
                out.write((Object)SipHeaderDecodingState.this.m_headers);
                return null;
            }
            return new HeaderNameDecodingState();
        }
    }

    private final class HeaderValueDecodingState
    extends ConsumeToCrlfDecodingState {
        private final String m_headerName;

        private HeaderValueDecodingState(String headerName) {
            this.m_headerName = headerName;
        }

        protected DecodingState finishDecode(ByteBuffer product, ProtocolDecoderOutput out) throws Exception {
            String headerValue = product.getString(SipHeaderDecodingState.this.m_asciiDecoder);
            SipHeaderDecodingState.this.LOG.debug("Read header value: {}", (Object)headerValue);
            SipHeader header = SipHeaderDecodingState.this.m_headerFactory.createHeader(this.m_headerName, headerValue);
            SipHeaderDecodingState.this.m_headers.put(this.m_headerName, header);
            return new FindEmptyLine();
        }
    }

    private final class AfterHeaderColonState
    extends SpaceSkippingState {
        private final String m_headerName;

        private AfterHeaderColonState(String headerName) {
            this.m_headerName = headerName;
        }

        protected DecodingState finishDecode() throws Exception {
            return new HeaderValueDecodingState(this.m_headerName);
        }
    }

    private final class HeaderNameDecodingState
    extends ConsumeToTerminatorDecodingState {
        private HeaderNameDecodingState() {
            super((byte)58);
        }

        protected DecodingState finishDecode(byte foundTerminator, ByteBuffer product, ProtocolDecoderOutput out) throws Exception {
            String headerName = product.getString(SipHeaderDecodingState.this.m_asciiDecoder);
            return new AfterHeaderColonState(headerName);
        }
    }
}

