/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.codec.decoder;

import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.littleshoot.mina.common.BufferDataException;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.filter.codec.ProtocolDecoder;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.mina.filter.codec.textline.TextLineDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipMessageDecoder
implements ProtocolDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(SipMessageDecoder.class);
    private static final String CONTEXT = TextLineDecoder.class.getName() + ".context";
    private final Charset charset = Charset.forName("US-ASCII");
    private ByteBuffer m_delimiterBuf = this.createDelimiterBuf("\r\n\r\n");
    private int maxLineLength = 1024;

    private ByteBuffer createDelimiterBuf(String delimiter) {
        ByteBuffer tmp = ByteBuffer.allocate((int)delimiter.length());
        try {
            tmp.putString((CharSequence)delimiter, this.charset.newEncoder());
            tmp.flip();
            return tmp;
        }
        catch (CharacterCodingException e) {
            LOG.error("Bad charset?", (Throwable)e);
            return null;
        }
    }

    public void decode(IoSession session, ByteBuffer in, ProtocolDecoderOutput out) throws Exception {
        Context ctx = this.getContext(session);
        int matchCount = this.decodeNormal(in, ctx, out);
        ctx.setMatchCount(matchCount);
    }

    private Context getContext(IoSession session) {
        Context ctx = (Context)session.getAttribute(CONTEXT);
        if (ctx == null) {
            ctx = new Context();
            session.setAttribute(CONTEXT, (Object)ctx);
        }
        return ctx;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }

    public void dispose(IoSession session) throws Exception {
        Context ctx = (Context)session.getAttribute(CONTEXT);
        if (ctx != null) {
            session.removeAttribute(CONTEXT);
        }
    }

    private int decodeNormal(ByteBuffer in, Context ctx, ProtocolDecoderOutput out) throws IOException {
        ByteBuffer buf = ctx.getBuffer();
        int matchCount = ctx.getMatchCount();
        CharsetDecoder decoder = ctx.getDecoder();
        int oldPos = in.position();
        int oldLimit = in.limit();
        int count = matchCount;
        while (in.hasRemaining()) {
            byte b = in.get();
            if (this.m_delimiterBuf.get(matchCount) == b) {
                ++count;
                if (matchCount != this.m_delimiterBuf.limit()) continue;
                int pos = in.position();
                in.limit(pos);
                in.position(oldPos);
                buf.put(in);
                if (buf.position() > this.maxLineLength) {
                    throw new BufferDataException("Line is too long: " + buf.position());
                }
                buf.flip();
                buf.limit(buf.limit() - matchCount);
                String headers = buf.getString(decoder);
                Map<String, SipHeader> headersMap = this.createHeadersMap(headers);
                ctx.setHeaders(headersMap);
                long contentLength = this.getContentLength(headersMap);
                buf.clear();
                in.limit(oldLimit);
                in.position(pos);
                oldPos = pos;
                count = 0;
                continue;
            }
            count = 0;
        }
        in.position(oldPos);
        buf.put(in);
        return count;
    }

    private long getContentLength(Map<String, SipHeader> headersMap) {
        SipHeader header = headersMap.get("Content-Length");
        if (header == null) {
            LOG.debug("Did not get content length header -- no body");
            return 0L;
        }
        String headerValue = header.getValue().getBaseValue();
        return Long.parseLong(headerValue);
    }

    private Map<String, SipHeader> createHeadersMap(String headers) throws IOException {
        ConcurrentHashMap<String, SipHeader> headersMap = new ConcurrentHashMap<String, SipHeader>();
        Scanner scan = new Scanner(headers);
        scan.useDelimiter("\r\n");
        while (scan.hasNext()) {
            String header = scan.next();
            this.addHeader(header, headersMap);
        }
        return headersMap;
    }

    private void addHeader(String headerString, Map<String, SipHeader> headers) throws IOException {
    }

    private class Context {
        private final CharsetDecoder decoder;
        private final ByteBuffer buf;
        private int matchCount = 0;
        private Map<String, SipHeader> m_headers;

        private Context() {
            this.decoder = SipMessageDecoder.this.charset.newDecoder();
            this.buf = ByteBuffer.allocate((int)80).setAutoExpand(true);
        }

        public void setHeaders(Map<String, SipHeader> headers) {
            this.m_headers = headers;
        }

        public CharsetDecoder getDecoder() {
            return this.decoder;
        }

        public ByteBuffer getBuffer() {
            return this.buf;
        }

        public int getMatchCount() {
            return this.matchCount;
        }

        public void setMatchCount(int matchCount) {
            this.matchCount = matchCount;
        }
    }
}

