/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.codec.decoder;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.lastbamboo.common.sip.stack.codec.SipMessageType;
import org.lastbamboo.common.sip.stack.codec.decoder.SipFirstLineDecodingState;
import org.lastbamboo.common.sip.stack.codec.decoder.SipHeaderDecodingState;
import org.lastbamboo.common.sip.stack.message.DoubleCrlfKeepAlive;
import org.lastbamboo.common.sip.stack.message.SingleSipMessageFactory;
import org.lastbamboo.common.sip.stack.message.SipInviteFactory;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.SipMessageUtils;
import org.lastbamboo.common.sip.stack.message.SipRegisterFactory;
import org.lastbamboo.common.sip.stack.message.SipResponseFactory;
import org.lastbamboo.common.sip.stack.message.UnknownSipRequestFactory;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderFactory;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ByteBufferAllocator;
import org.littleshoot.mina.common.SimpleByteBufferAllocator;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.DecodingState;
import org.littleshoot.util.mina.DecodingStateMachine;
import org.littleshoot.util.mina.FixedLengthDecodingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipMessageDecodingState
extends DecodingStateMachine {
    private final Logger LOG = LoggerFactory.getLogger(SipMessageDecodingState.class);
    private static final ByteBuffer EMPTY_BODY;
    private SingleSipMessageFactory m_messageFactory;
    private final SipHeaderFactory m_headerFactory;

    public SipMessageDecodingState(SipHeaderFactory headerFactory) {
        this.m_headerFactory = headerFactory;
    }

    protected DecodingState init() {
        return new ReadFirstLineState();
    }

    protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) {
        this.LOG.error("Got finish decode for full message");
        return null;
    }

    protected void destroy() {
    }

    static {
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        EMPTY_BODY = ByteBuffer.allocate((int)0);
    }

    private final class ReadBodyState
    extends FixedLengthDecodingState {
        private final Map<String, SipHeader> m_headers;

        private ReadBodyState(Map<String, SipHeader> headers, int length) {
            super(length);
            this.m_headers = headers;
        }

        protected DecodingState finishDecode(ByteBuffer readData, ProtocolDecoderOutput out) throws Exception {
            SipMessageDecodingState.this.LOG.debug("Returning SIP message with body...");
            SipMessage message = SipMessageDecodingState.this.m_messageFactory.createSipMessage(this.m_headers, readData);
            out.write((Object)message);
            return null;
        }
    }

    private final class ReadHeadersState
    extends SipHeaderDecodingState {
        private ReadHeadersState(SipHeaderFactory headerFactory) {
            super(headerFactory);
        }

        protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
            Map headers = (Map)childProducts.get(0);
            int length = SipMessageUtils.extractContentLength(headers);
            if (length > 0) {
                SipMessageDecodingState.this.LOG.debug("Reading body with length: {}", (Object)length);
                return new ReadBodyState(headers, length);
            }
            SipMessageDecodingState.this.LOG.debug("Returning SIP message with NO body...");
            SipMessage message = SipMessageDecodingState.this.m_messageFactory.createSipMessage(headers, EMPTY_BODY);
            out.write((Object)message);
            return null;
        }
    }

    private final class ReadFirstLineState
    extends SipFirstLineDecodingState {
        private ReadFirstLineState() {
        }

        protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
            SipMessageType messageType = (SipMessageType)((Object)childProducts.get(0));
            if (SipMessageDecodingState.this.LOG.isDebugEnabled()) {
                SipMessageDecodingState.this.LOG.debug("Handling message type: " + (Object)((Object)messageType));
            }
            switch (messageType) {
                case SIP_2_0: {
                    int statusCode = (Integer)childProducts.get(1);
                    String reasonPhrase = (String)childProducts.get(2);
                    SipMessageDecodingState.this.m_messageFactory = new SipResponseFactory(statusCode, reasonPhrase);
                    break;
                }
                case REGISTER: {
                    URI registerUri = (URI)childProducts.get(1);
                    SipMessageDecodingState.this.m_messageFactory = new SipRegisterFactory(registerUri);
                    break;
                }
                case INVITE: {
                    URI inviteUri = (URI)childProducts.get(1);
                    SipMessageDecodingState.this.m_messageFactory = new SipInviteFactory(inviteUri);
                    break;
                }
                case DOUBLE_CRLF: {
                    DoubleCrlfKeepAlive doubleCrlf = new DoubleCrlfKeepAlive();
                    out.write((Object)doubleCrlf);
                    return null;
                }
                case UNKNOWN: {
                    URI uri = (URI)childProducts.get(1);
                    SipMessageDecodingState.this.m_messageFactory = new UnknownSipRequestFactory("Unknown", uri);
                    break;
                }
                default: {
                    SipMessageDecodingState.this.LOG.warn("Not handling type: " + (Object)((Object)messageType));
                }
            }
            return new ReadHeadersState(SipMessageDecodingState.this.m_headerFactory);
        }
    }
}

