/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.codec.encoder;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lastbamboo.common.sip.stack.codec.encoder.SipMessageEncoder;
import org.lastbamboo.common.sip.stack.message.DoubleCrlfKeepAlive;
import org.lastbamboo.common.sip.stack.message.Invite;
import org.lastbamboo.common.sip.stack.message.Register;
import org.lastbamboo.common.sip.stack.message.RequestTimeoutResponse;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.SipMessageVisitor;
import org.lastbamboo.common.sip.stack.message.SipResponse;
import org.lastbamboo.common.sip.stack.message.UnknownSipRequest;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderValue;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.util.mina.MinaCodecUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipMessageEncoderImpl
implements SipMessageEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(SipMessageEncoderImpl.class);

    @Override
    public ByteBuffer encode(SipMessage message) {
        ByteBuffer buffer = ByteBuffer.allocate((int)300);
        buffer.setAutoExpand(true);
        EncoderVisitor visitor = new EncoderVisitor(buffer);
        message.accept(visitor);
        buffer.flip();
        return buffer;
    }

    private static final class EncoderVisitor
    implements SipMessageVisitor {
        private static final Charset US_ASCII = Charset.forName("US-ASCII");
        private final CharsetEncoder m_asciiEncoder = US_ASCII.newEncoder();
        private final ByteBuffer m_buffer;

        private EncoderVisitor(ByteBuffer buffer) {
            this.m_buffer = buffer;
        }

        private final void standardEncode(SipMessage message) {
            this.encodeStartLine(message, this.m_buffer);
            this.encodeHeaders(message, this.m_buffer);
            this.encodeBody(message, this.m_buffer);
        }

        @Override
        public void visitDoubleCrlfKeepAlive(DoubleCrlfKeepAlive keepAlive) {
            MinaCodecUtils.appendCRLF((ByteBuffer)this.m_buffer);
            MinaCodecUtils.appendCRLF((ByteBuffer)this.m_buffer);
        }

        @Override
        public void visitInvite(Invite invite) {
            this.standardEncode(invite);
        }

        @Override
        public void visitRegister(Register register) {
            this.standardEncode(register);
        }

        @Override
        public void visitRequestTimedOut(RequestTimeoutResponse response) {
            this.standardEncode(response);
        }

        @Override
        public void visitResponse(SipResponse response) {
            this.standardEncode(response);
        }

        @Override
        public void visitUnknownRequest(UnknownSipRequest request) {
        }

        private void encodeStartLine(SipMessage message, ByteBuffer buffer) {
            LOG.debug("Encoding start line: '{}'", (Object)message.getStartLine());
            try {
                buffer.putString((CharSequence)message.getStartLine(), this.m_asciiEncoder);
            }
            catch (CharacterCodingException e) {
                LOG.error("Bad encoding?", (Throwable)e);
            }
            MinaCodecUtils.appendCRLF((ByteBuffer)buffer);
        }

        private void encodeHeaders(SipMessage message, ByteBuffer buffer) {
            LOG.debug("Appending headers: {}", message.getHeaders());
            Map<String, SipHeader> headers = message.getHeaders();
            for (Map.Entry<String, SipHeader> entry : headers.entrySet()) {
                SipHeader header = entry.getValue();
                List<SipHeaderValue> values = header.getValues();
                try {
                    buffer.putString((CharSequence)header.getName(), this.m_asciiEncoder);
                    buffer.put((byte)58);
                    buffer.put((byte)32);
                    this.appendHeaderValues(buffer, values);
                    MinaCodecUtils.appendCRLF((ByteBuffer)buffer);
                }
                catch (CharacterCodingException e) {
                    LOG.error("Bad encoding?", (Throwable)e);
                }
            }
            MinaCodecUtils.appendCRLF((ByteBuffer)buffer);
        }

        private void appendHeaderValues(ByteBuffer buffer, List<SipHeaderValue> values) throws CharacterCodingException {
            Iterator<SipHeaderValue> iter = values.iterator();
            while (iter.hasNext()) {
                SipHeaderValue value = iter.next();
                buffer.putString((CharSequence)value.getBaseValue(), this.m_asciiEncoder);
                Map<String, String> params = value.getParams();
                Set<Map.Entry<String, String>> entries = params.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    buffer.put((byte)59);
                    buffer.putString((CharSequence)entry.getKey(), this.m_asciiEncoder);
                    buffer.put((byte)61);
                    buffer.putString((CharSequence)entry.getValue(), this.m_asciiEncoder);
                }
                if (!iter.hasNext()) continue;
                buffer.put((byte)44);
            }
        }

        private void encodeBody(SipMessage message, ByteBuffer buffer) {
            ByteBuffer body = message.getBody();
            buffer.put(body);
        }
    }
}

