/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.codec.encoder;

import org.lastbamboo.common.sip.stack.codec.encoder.SipMessageEncoder;
import org.lastbamboo.common.sip.stack.codec.encoder.SipMessageEncoderImpl;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoFuture;
import org.littleshoot.mina.common.IoFutureListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.filter.codec.ProtocolEncoder;
import org.littleshoot.mina.filter.codec.ProtocolEncoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipMessageProtocolEncoder
implements ProtocolEncoder,
IoFutureListener {
    private final Logger LOG = LoggerFactory.getLogger(SipMessageProtocolEncoder.class);
    private final SipMessageEncoder m_encoder = new SipMessageEncoderImpl();
    private static volatile int s_encodesCompleted = 0;
    private static volatile int s_encodeAttempts = 0;

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        ++s_encodeAttempts;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Attempted encodes: " + s_encodeAttempts);
        }
        ByteBuffer buffer = this.m_encoder.encode((SipMessage)message);
        out.write(buffer);
    }

    public void dispose(IoSession session) throws Exception {
    }

    public void operationComplete(IoFuture future) {
        ++s_encodesCompleted;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Completed encodes: " + s_encodesCompleted);
        }
    }
}

