/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.message;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lastbamboo.common.sip.stack.codec.SipMessageType;
import org.lastbamboo.common.sip.stack.codec.SipMethod;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.SipMessageUtils;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderValue;
import org.littleshoot.mina.common.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSipMessage
implements SipMessage {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSipMessage.class);
    private final Map<String, SipHeader> m_headers;
    private final SipMethod m_method;
    private final String m_startLine;
    private final ByteBuffer m_messageBody;
    private static final ByteBuffer EMPTY_BODY = ByteBuffer.allocate((int)0);

    public AbstractSipMessage(String startLine, SipMethod method, Map<String, SipHeader> headers, ByteBuffer body) {
        this.m_startLine = startLine;
        this.m_headers = headers;
        this.m_method = method;
        this.m_messageBody = body.asReadOnlyBuffer();
    }

    public AbstractSipMessage(SipMethod method, URI requestUri, Map<String, SipHeader> headers) {
        this(method, requestUri, headers, EMPTY_BODY);
    }

    public AbstractSipMessage(SipMethod method, URI requestUri, Map<String, SipHeader> headers, ByteBuffer body) {
        this(AbstractSipMessage.createRequestLine(method, requestUri), method, headers, body);
    }

    public AbstractSipMessage(int statusCode, String reasonPhrase, Map<String, SipHeader> headers, ByteBuffer body) {
        this(AbstractSipMessage.createResponseStatusLine(statusCode, reasonPhrase), AbstractSipMessage.createMethod(headers), headers, body);
    }

    public AbstractSipMessage(int statusCode, String reasonPhrase, Map<String, SipHeader> headers) {
        this(AbstractSipMessage.createResponseStatusLine(statusCode, reasonPhrase), AbstractSipMessage.createMethod(headers), headers, EMPTY_BODY);
    }

    private static SipMethod createMethod(Map<String, SipHeader> headers) {
        SipHeader cseq = headers.get("CSeq");
        String methodString = SipMessageUtils.extractCSeqMethod(cseq);
        return SipMethod.valueOf(methodString);
    }

    private static String createResponseStatusLine(int statusCode, String reasonPhrase) {
        StringBuilder sb = new StringBuilder();
        sb.append(SipMessageType.SIP_2_0.convert());
        sb.append(" ");
        sb.append(statusCode);
        sb.append(" ");
        sb.append(reasonPhrase);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning response line: " + sb.toString());
        }
        return sb.toString();
    }

    private static String createRequestLine(SipMethod method, URI requestUri) {
        return AbstractSipMessage.createRequestLine(method.name(), requestUri);
    }

    protected static String createRequestLine(String method, URI requestUri) {
        StringBuilder sb = new StringBuilder();
        sb.append(method);
        sb.append(" ");
        sb.append(requestUri);
        sb.append(" ");
        sb.append(SipMessageType.SIP_2_0.convert());
        return sb.toString();
    }

    @Override
    public SipHeader getHeader(String headerName) {
        return this.m_headers.get(headerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, SipHeader> getHeaders() {
        Map<String, SipHeader> map = this.m_headers;
        synchronized (map) {
            return new ConcurrentHashMap<String, SipHeader>(this.m_headers);
        }
    }

    @Override
    public ByteBuffer getBody() {
        return this.m_messageBody;
    }

    @Override
    public final String getBranchId() {
        SipHeader via = this.m_headers.get("Via");
        return via.getValue().getParamValue("branch");
    }

    @Override
    public final SipMethod getMethod() {
        return this.m_method;
    }

    @Override
    public List<SipHeaderValue> getRouteSet() {
        SipHeader recordRoute = this.m_headers.get("Record-Route");
        if (recordRoute == null) {
            return Collections.emptyList();
        }
        return recordRoute.getValues();
    }

    @Override
    public String getStartLine() {
        return this.m_startLine;
    }

    public String getTransactionKey() {
        String branchId = this.getBranchId();
        SipMethod method = this.getMethod();
        return branchId + method.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public byte[] getKey() {
        return null;
    }
}

