/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.message;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.lastbamboo.common.sip.stack.codec.SipMethod;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.SipMessageVisitor;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderValue;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.util.StringUtils;

public class DoubleCrlfKeepAlive
implements SipMessage {
    private static final ByteBuffer DOUBLE_CRLF = ByteBuffer.wrap((byte[])StringUtils.toAsciiBytes((String)"\r\n\r\n"));

    @Override
    public void accept(SipMessageVisitor visitor) {
        visitor.visitDoubleCrlfKeepAlive(this);
    }

    @Override
    public ByteBuffer getBody() {
        return DOUBLE_CRLF.duplicate();
    }

    @Override
    public String getBranchId() {
        return "";
    }

    @Override
    public SipHeader getHeader(String headerName) {
        return null;
    }

    @Override
    public Map<String, SipHeader> getHeaders() {
        return Collections.emptyMap();
    }

    @Override
    public SipMethod getMethod() {
        return SipMethod.DOUBLE_CRLF_KEEP_ALIVE;
    }

    @Override
    public List<SipHeaderValue> getRouteSet() {
        return Collections.emptyList();
    }

    @Override
    public String getStartLine() {
        return "";
    }

    public String getTransactionKey() {
        String branchId = this.getBranchId();
        SipMethod method = this.getMethod();
        return branchId + method.toString();
    }

    public byte[] getKey() {
        return null;
    }
}

