/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.message;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.id.uuid.UUID;
import org.apache.commons.lang.StringUtils;
import org.lastbamboo.common.sip.stack.message.Invite;
import org.lastbamboo.common.sip.stack.message.Register;
import org.lastbamboo.common.sip.stack.message.RequestTimeoutResponse;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.SipMessageFactory;
import org.lastbamboo.common.sip.stack.message.SipResponse;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderFactory;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderFactoryImpl;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderImpl;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderValue;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderValueImpl;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ByteBufferAllocator;
import org.littleshoot.mina.common.SimpleByteBufferAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipMessageFactoryImpl
implements SipMessageFactory {
    private final Logger LOG = LoggerFactory.getLogger(SipMessageFactoryImpl.class);
    private final SipHeaderFactory m_headerFactory;
    private static final ByteBuffer EMPTY_BODY;

    public SipMessageFactoryImpl(SipHeaderFactory headerFactory) {
        this.m_headerFactory = headerFactory;
    }

    public SipMessageFactoryImpl() {
        this(new SipHeaderFactoryImpl());
    }

    @Override
    public Register createRegisterRequest(URI requestUri, String displayName, URI toUri, UUID instanceId, URI contactUri) {
        Map<String, SipHeader> headers = this.createHeaders("REGISTER", displayName, toUri, toUri, instanceId, contactUri, 0);
        return new Register(requestUri, headers);
    }

    @Override
    public Invite createInviteRequest(String displayName, URI toUri, URI fromUri, UUID instanceId, URI contactUri, ByteBuffer body) {
        Map<String, SipHeader> headers = this.createHeaders("INVITE", displayName, toUri, fromUri, instanceId, contactUri, body.capacity());
        return new Invite(toUri, headers, body);
    }

    private Map<String, SipHeader> createHeaders(String method, String displayName, URI toUri, URI fromUri, UUID instanceId, URI contactUri, int contentLength) {
        ConcurrentHashMap<String, SipHeader> headers = new ConcurrentHashMap<String, SipHeader>();
        SipHeader curHeader = this.m_headerFactory.createMaxForwards(70);
        headers.put(curHeader.getName(), curHeader);
        curHeader = this.m_headerFactory.createTo(toUri);
        headers.put(curHeader.getName(), curHeader);
        curHeader = this.m_headerFactory.createFrom(displayName, fromUri);
        headers.put(curHeader.getName(), curHeader);
        curHeader = this.m_headerFactory.createCallId();
        headers.put(curHeader.getName(), curHeader);
        curHeader = this.m_headerFactory.createCSeq(method);
        headers.put(curHeader.getName(), curHeader);
        curHeader = this.m_headerFactory.createContact(contactUri, instanceId);
        headers.put(curHeader.getName(), curHeader);
        curHeader = this.m_headerFactory.createExpires(7200);
        headers.put(curHeader.getName(), curHeader);
        curHeader = this.m_headerFactory.createContentLength(contentLength);
        headers.put(curHeader.getName(), curHeader);
        return headers;
    }

    @Override
    public SipResponse createInviteOk(Invite request, UUID instanceId, URI contactUri, ByteBuffer body) {
        Map<String, SipHeader> headers = this.createResponseHeaders(request);
        this.addRecordRoute(request, headers);
        this.addContact(headers, instanceId, contactUri);
        this.addContentLength(headers, body.capacity());
        SipResponse response = new SipResponse(200, "OK", headers, body);
        return response;
    }

    @Override
    public SipMessage createErrorResponse(SipMessage request, UUID instanceId, URI contactUri, int responseCode, String reasonPhrase) {
        Map<String, SipHeader> headers = this.createResponseHeaders(request);
        this.addRecordRoute(request, headers);
        this.addContact(headers, instanceId, contactUri);
        SipResponse response = new SipResponse(responseCode, reasonPhrase, headers);
        return response;
    }

    @Override
    public Register addVia(Register message, SipHeader newHeader) {
        Map<String, SipHeader> headers = this.addVia(message.getHeaders(), newHeader);
        return new Register(message.getStartLine(), headers, message.getBody());
    }

    @Override
    public Invite addVia(Invite message, SipHeader newHeader) {
        Map<String, SipHeader> headers = this.addVia(message.getHeaders(), newHeader);
        return new Invite(message.getStartLine(), headers, message.getBody());
    }

    private Map<String, SipHeader> addVia(Map<String, SipHeader> headers, SipHeader newHeader) {
        SipHeader header = headers.get(newHeader.getName());
        if (header == null) {
            headers.put(newHeader.getName(), newHeader);
        } else {
            List<SipHeaderValue> values = header.getValues();
            values.addAll(0, newHeader.getValues());
            SipHeaderImpl copy = new SipHeaderImpl(newHeader.getName(), values);
            headers.put(copy.getName(), copy);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Created new Via header: " + copy);
            }
        }
        return headers;
    }

    @Override
    public SipResponse stripVia(SipResponse response) {
        Map<String, SipHeader> headers = response.getHeaders();
        SipHeader viaHeader = headers.remove("Via");
        List<SipHeaderValue> vias = viaHeader.getValues();
        SipHeaderValue ourVia = vias.remove(0);
        SipHeaderImpl strippedVia = new SipHeaderImpl("Via", vias);
        headers.put("Via", strippedVia);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Removed Via header: " + ourVia);
        }
        return new SipResponse(response.getStatusCode(), response.getReasonPhrase(), headers, response.getBody());
    }

    @Override
    public SipResponse createRegisterOk(Register request) {
        Map<String, SipHeader> headers = this.createResponseHeaders(request);
        SipHeader supported = this.m_headerFactory.createSupported();
        headers.put(supported.getName(), supported);
        return new SipResponse(200, "OK", headers, EMPTY_BODY);
    }

    private void addContact(Map<String, SipHeader> headers, UUID instanceId, URI contactUri) {
        SipHeader contact = this.m_headerFactory.createContact(contactUri, instanceId);
        headers.put(contact.getName(), contact);
    }

    private void addContentLength(Map<String, SipHeader> headers, int length) {
        SipHeader contentLength = this.m_headerFactory.createContentLength(length);
        headers.put(contentLength.getName(), contentLength);
    }

    private void addRecordRoute(SipMessage request, Map<String, SipHeader> headers) {
        this.copyHeader(headers, request, "Record-Route");
    }

    @Override
    public SipResponse createRequestTimeoutResponse(SipMessage request) {
        Map<String, SipHeader> headers = this.createResponseHeaders(request);
        return new RequestTimeoutResponse(headers);
    }

    private Map<String, SipHeader> createResponseHeaders(SipMessage request) {
        ConcurrentHashMap<String, SipHeader> headers = new ConcurrentHashMap<String, SipHeader>();
        this.copyHeader(headers, request, "From");
        this.copyHeader(headers, request, "Call-ID");
        this.copyHeader(headers, request, "CSeq");
        this.copyHeader(headers, request, "Via");
        this.handleToHeader(headers, request);
        return headers;
    }

    private void handleToHeader(Map<String, SipHeader> headers, SipMessage request) {
        SipHeader to = request.getHeader("To");
        if (to.getValue().hasParam("tag")) {
            this.copyHeader(headers, request, "To");
        } else {
            SipHeader toWithTag = this.m_headerFactory.createTo(to);
            headers.put(toWithTag.getName(), toWithTag);
        }
    }

    private void copyHeader(Map<String, SipHeader> headers, SipMessage request, String headerName) {
        SipHeader header = request.getHeader(headerName);
        if (header == null) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("No header for name: " + headerName);
            }
            return;
        }
        headers.put(header.getName(), header);
    }

    @Override
    public Invite createInviteToForward(InetSocketAddress socketAddress, Invite invite) throws IOException {
        SipHeaderValue viaValue;
        String fullSentByString;
        SipHeader via = invite.getHeader("Via");
        if (via == null) {
            this.LOG.warn("No Via in message: " + invite);
            throw new IOException("No Via in message: " + invite);
        }
        List<SipHeaderValue> viaValues = via.getValues();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Processing " + viaValues.size() + " vias...");
        }
        if (StringUtils.isBlank((String)(fullSentByString = StringUtils.substringAfter((String)(viaValue = viaValues.remove(0)).getBaseValue(), (String)" ")))) {
            this.LOG.warn("Blank sent-by in Via: " + via);
            return null;
        }
        String sentByHost = StringUtils.contains((String)fullSentByString, (String)":") ? StringUtils.substringBefore((String)fullSentByString, (String)":") : fullSentByString;
        String host = socketAddress.getAddress().getHostAddress();
        int rport = socketAddress.getPort();
        Map<String, String> params = viaValue.getParams();
        if (!host.equals(sentByHost)) {
            params.put("received", host);
        }
        params.put("rport", Integer.toString(rport));
        SipHeaderValueImpl viaValueCopy = new SipHeaderValueImpl(viaValue.getBaseValue(), params);
        viaValues.add(0, viaValueCopy);
        SipHeaderImpl newVia = new SipHeaderImpl("Via", viaValues);
        Map<String, SipHeader> headers = invite.getHeaders();
        headers.put(newVia.getName(), newVia);
        return new Invite(invite.getStartLine(), headers, invite.getBody());
    }

    static {
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        EMPTY_BODY = ByteBuffer.allocate((int)0);
    }
}

