/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.message;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderImpl;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderValue;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderValueImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipMessageUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SipMessageUtils.class);

    private SipMessageUtils() {
    }

    public static String toParamString(Map paramsMap) {
        StringBuilder sb = new StringBuilder();
        Set params = paramsMap.entrySet();
        for (Map.Entry entry : params) {
            sb.append(";");
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
        }
        return sb.toString();
    }

    public static String extractName(String nameValue) throws IOException {
        return SipMessageUtils.extractName(nameValue, ":");
    }

    public static String extractValue(String nameValue) throws IOException {
        return SipMessageUtils.extractValue(nameValue, ":");
    }

    private static String extractName(String nameValue, String separator) throws IOException {
        String name = StringUtils.substringBefore((String)nameValue, (String)separator);
        if (StringUtils.isBlank((String)name)) {
            throw new IOException("Bad header: " + nameValue);
        }
        return name.trim();
    }

    private static String extractValue(String nameValue, String separator) throws IOException {
        String value = StringUtils.substringAfter((String)nameValue, (String)separator);
        if (StringUtils.isBlank((String)value)) {
            throw new IOException("Bad header: " + nameValue);
        }
        return value.trim();
    }

    public static Map<String, SipHeader> convertHeaders(Map<String, List<String>> headers) {
        HashMap<String, SipHeader> newHeaders = new HashMap<String, SipHeader>();
        Set<Map.Entry<String, List<String>>> entries = headers.entrySet();
        for (Map.Entry<String, List<String>> entry : entries) {
            List<String> values = entry.getValue();
            List<SipHeaderValue> headerValues = SipMessageUtils.createValues(values);
            SipHeaderImpl header = new SipHeaderImpl(entry.getKey(), headerValues);
            newHeaders.put(header.getName(), header);
        }
        return newHeaders;
    }

    private static List<SipHeaderValue> createValues(List<String> values) {
        LinkedList<SipHeaderValue> headerValues = new LinkedList<SipHeaderValue>();
        for (String value : values) {
            Scanner scan = new Scanner(value);
            scan.useDelimiter(",");
            while (scan.hasNext()) {
                String curValue = scan.next();
                try {
                    SipHeaderValueImpl headerValue = new SipHeaderValueImpl(curValue);
                    headerValues.add(headerValue);
                }
                catch (IOException e) {
                    LOG.warn("Could not parse header value: " + value);
                }
            }
        }
        return headerValues;
    }

    public static Map<String, String> extractHeaderParams(String headerValue) throws IOException {
        String paramsString = StringUtils.substringAfter((String)headerValue, (String)";");
        String[] paramStrings = StringUtils.split((String)paramsString, (String)";");
        ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
        for (int i = 0; i < paramStrings.length; ++i) {
            String nameValue = paramStrings[i].trim();
            String name = SipMessageUtils.extractName(nameValue, "=");
            String value = SipMessageUtils.extractValue(nameValue, "=");
            paramMap.put(name, value);
        }
        return paramMap;
    }

    public static String extractCSeqMethod(SipHeader cseq) {
        return StringUtils.substringAfter((String)cseq.getValue().getBaseValue(), (String)" ");
    }

    public static URI extractUri(SipHeader header) {
        return SipMessageUtils.extractUri(header.getValue().getBaseValue());
    }

    private static URI extractUri(String headerValue) {
        LOG.debug("Creating URI from header value: " + headerValue);
        String uriString = StringUtils.substringBetween((String)headerValue, (String)"<", (String)">");
        LOG.debug("Creating URI from URI string: " + uriString);
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            LOG.error("Could not create URI from string: " + uriString);
            throw new IllegalArgumentException("Could not create URI from: " + uriString);
        }
    }

    public static int extractCSeqNumber(SipMessage message) {
        SipHeaderValue cSeqValue = message.getHeader("CSeq").getValue();
        String cSeqString = cSeqValue.getBaseValue();
        String sequenceString = StringUtils.substringBefore((String)cSeqString, (String)" ");
        if (!NumberUtils.isNumber((String)sequenceString)) {
            throw new IllegalArgumentException("Bad cseq: " + cSeqString);
        }
        return Integer.parseInt(sequenceString);
    }

    public static URI extractUriFromRequestLine(SipMessage request) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extracting URI from request line: " + request.getStartLine());
        }
        String requestLine = request.getStartLine();
        String uri = StringUtils.substringBetween((String)requestLine, (String)" ");
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            LOG.warn("COuld not parse URI", (Throwable)e);
            throw new IOException("Attempted to parse invalid URI in request line: " + requestLine);
        }
    }

    public static InetAddress extractSentByFromVia(SipHeaderValue via) throws UnknownHostException {
        String baseValue = via.getBaseValue();
        String hostString = StringUtils.substringAfterLast((String)baseValue, (String)" ");
        return InetAddress.getByName(hostString);
    }

    public static InetSocketAddress extractNextHopFromVia(SipMessage message) throws IOException {
        String hostString;
        SipHeaderValue topMostVia;
        String portString;
        SipHeader via = message.getHeader("Via");
        if (via == null) {
            LOG.warn("No Via header in message: " + message);
            throw new IOException("No Via header in message!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Accessing value for Via: " + via);
        }
        if (StringUtils.isBlank((String)(portString = (topMostVia = via.getValue()).getParamValue("rport")))) {
            LOG.warn("No port in Via: " + topMostVia);
            throw new IOException("Can't handle via with no port");
        }
        int port = Integer.parseInt(portString);
        if (topMostVia.hasParam("received")) {
            hostString = topMostVia.getParamValue("received");
        } else {
            LOG.debug("Not using received parameter...");
            String baseValue = topMostVia.getBaseValue();
            hostString = StringUtils.substringAfterLast((String)baseValue, (String)" ");
            LOG.debug("Using host string: " + hostString);
        }
        return new InetSocketAddress(hostString, port);
    }

    public static int extractContentLength(Map<String, SipHeader> headers) {
        SipHeader header = headers.get("Content-Length");
        if (header == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No Content-Length header");
            }
            return 0;
        }
        String lengthString = header.getValue().getBaseValue();
        if (!NumberUtils.isNumber((String)lengthString)) {
            LOG.warn("Content-Length not a number: " + lengthString);
            return 0;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing length: " + lengthString);
        }
        return Integer.parseInt(lengthString);
    }
}

