/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.message.header;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.apache.commons.lang.StringUtils;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderFactory;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderImpl;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderValue;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderValueImpl;
import org.littleshoot.util.RuntimeIoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipHeaderFactoryImpl
implements SipHeaderFactory {
    private final Logger LOG = LoggerFactory.getLogger(SipHeaderFactoryImpl.class);
    private static int sequenceNumber = 1;

    @Override
    public SipHeader createHeader(String name, String value) {
        List<SipHeaderValue> headerValues;
        try {
            headerValues = this.createHeaderValues(value);
        }
        catch (IOException e) {
            this.LOG.error("Could not parse header");
            throw new RuntimeIoException((Exception)e);
        }
        return new SipHeaderImpl(name, headerValues);
    }

    private List<SipHeaderValue> createHeaderValues(String headerValueString) throws IOException {
        ArrayList<SipHeaderValue> valuesList = new ArrayList<SipHeaderValue>();
        if (!StringUtils.contains((String)headerValueString, (String)",")) {
            SipHeaderValueImpl value = new SipHeaderValueImpl(headerValueString);
            valuesList.add(value);
            return valuesList;
        }
        String[] values = StringUtils.split((String)headerValueString, (String)",");
        for (int i = 0; i < values.length; ++i) {
            SipHeaderValueImpl value = new SipHeaderValueImpl(values[i].trim());
            valuesList.add(value);
        }
        return valuesList;
    }

    @Override
    public SipHeader createSentByVia(InetAddress address) {
        String baseValue = "SIP/2.0/TCP " + address.getHostAddress();
        Map<String, String> params = this.createParams("branch", this.createBranchId());
        return new SipHeaderImpl("Via", new SipHeaderValueImpl(baseValue, params));
    }

    @Override
    public SipHeader createMaxForwards(int maxForwards) {
        String valueString = Integer.toString(maxForwards);
        SipHeaderValueImpl value = new SipHeaderValueImpl(valueString, Collections.EMPTY_MAP);
        return new SipHeaderImpl("Max-Forwards", value);
    }

    @Override
    public SipHeader createSupported() {
        String valueString = "outbound";
        SipHeaderValueImpl value = new SipHeaderValueImpl("outbound", Collections.EMPTY_MAP);
        return new SipHeaderImpl("Supported", value);
    }

    @Override
    public SipHeader createTo(URI sipUri) {
        String valueString = "Anonymous <" + sipUri + ">";
        SipHeaderValueImpl value = new SipHeaderValueImpl(valueString, Collections.EMPTY_MAP);
        return new SipHeaderImpl("To", value);
    }

    @Override
    public SipHeader createTo(SipHeader originalTo) {
        SipHeaderValue value = originalTo.getValue();
        Map<String, String> params = value.getParams();
        params.put("tag", this.createTagValue());
        SipHeaderValueImpl copy = new SipHeaderValueImpl(value.getBaseValue(), params);
        return new SipHeaderImpl("To", copy);
    }

    @Override
    public SipHeader createFrom(String displayName, URI sipUri) {
        String baseValue = displayName + " <" + sipUri + ">";
        Map<String, String> params = this.createParams("tag", this.createTagValue());
        SipHeaderValueImpl value = new SipHeaderValueImpl(baseValue, params);
        return new SipHeaderImpl("From", value);
    }

    @Override
    public SipHeader createCallId() {
        String valueString = this.createCallIdValue();
        SipHeaderValueImpl value = new SipHeaderValueImpl(valueString, Collections.EMPTY_MAP);
        return new SipHeaderImpl("Call-ID", value);
    }

    @Override
    public SipHeader createCSeq(String method) {
        String valueString = this.createCSeqValue(method);
        SipHeaderValueImpl value = new SipHeaderValueImpl(valueString, Collections.EMPTY_MAP);
        return new SipHeaderImpl("CSeq", value);
    }

    @Override
    public SipHeader createContact(URI contactUri, UUID instanceId) {
        String baseValue = "<" + contactUri + ">";
        String sipInstanceValue = "\"<" + instanceId.toUrn() + ">\"";
        Map<String, String> params = this.createParams("+sip.instance", sipInstanceValue);
        SipHeaderValueImpl value = new SipHeaderValueImpl(baseValue, params);
        return new SipHeaderImpl("Contact", value);
    }

    @Override
    public SipHeader createExpires(int millis) {
        String valueString = Integer.toString(millis);
        SipHeaderValueImpl value = new SipHeaderValueImpl(valueString, Collections.EMPTY_MAP);
        return new SipHeaderImpl("Expires", value);
    }

    @Override
    public SipHeader createContentLength(int contentLength) {
        String valueString = Integer.toString(contentLength);
        SipHeaderValueImpl value = new SipHeaderValueImpl(valueString, Collections.EMPTY_MAP);
        return new SipHeaderImpl("Content-Length", value);
    }

    private String createTagValue() {
        UUID id = UUID.randomUUID();
        String urn = id.toUrn();
        return urn.substring(9, 19);
    }

    private String createCallIdValue() {
        UUID id = UUID.randomUUID();
        return id.toUrn().substring(10, 18);
    }

    private String createBranchId() {
        UUID id = UUID.randomUUID();
        return "z9hG4bK" + id.toUrn().substring(10, 17);
    }

    private String createCSeqValue(String method) {
        return ++sequenceNumber + " " + method;
    }

    private Map<String, String> createParams(String name, String value) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(name, value);
        return params;
    }
}

