/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.message.header;

import java.util.ArrayList;
import java.util.List;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipHeaderImpl
implements SipHeader {
    private static final Logger LOG = LoggerFactory.getLogger(SipHeaderImpl.class);
    private final String m_headerName;
    private final List<SipHeaderValue> m_headerValues;

    public SipHeaderImpl(String headerName, List<SipHeaderValue> headerValues) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating header with " + headerValues.size() + " values...");
        }
        this.m_headerName = headerName;
        this.m_headerValues = headerValues;
    }

    public SipHeaderImpl(String headerName, SipHeaderValue headerValue) {
        this(headerName, SipHeaderImpl.createValues(headerValue));
    }

    private static List<SipHeaderValue> createValues(SipHeaderValue headerValue) {
        ArrayList<SipHeaderValue> values = new ArrayList<SipHeaderValue>();
        values.add(headerValue);
        return values;
    }

    @Override
    public String getName() {
        return this.m_headerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SipHeaderValue> getValues() {
        List<SipHeaderValue> list = this.m_headerValues;
        synchronized (list) {
            return new ArrayList<SipHeaderValue>(this.m_headerValues);
        }
    }

    @Override
    public SipHeaderValue getValue() {
        return this.m_headerValues.get(0);
    }

    @Override
    public void addValue(SipHeaderValue headerValue) {
        this.m_headerValues.add(0, headerValue);
    }

    public String toString() {
        return this.m_headerName + ": " + this.getValues();
    }
}

