/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.message.header;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.lastbamboo.common.sip.stack.message.SipMessageUtils;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderValue;

public class SipHeaderValueImpl
implements SipHeaderValue {
    private final Map<String, String> m_params;
    private final String m_baseValue;

    public SipHeaderValueImpl(String valueString) throws IOException {
        this.m_baseValue = this.createBaseValue(valueString);
        this.m_params = SipMessageUtils.extractHeaderParams(valueString);
    }

    public SipHeaderValueImpl(String baseValue, Map<String, String> params) {
        this.m_baseValue = baseValue;
        this.m_params = params;
    }

    private String createBaseValue(String valueString) {
        if (StringUtils.contains((String)valueString, (String)";")) {
            return StringUtils.substringBefore((String)valueString, (String)";");
        }
        return valueString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getParams() {
        Map<String, String> map = this.m_params;
        synchronized (map) {
            return new ConcurrentHashMap<String, String>(this.m_params);
        }
    }

    @Override
    public String getBaseValue() {
        return this.m_baseValue;
    }

    @Override
    public boolean hasParam(String paramName) {
        return this.m_params.containsKey(paramName);
    }

    @Override
    public String getParamValue(String paramName) {
        return this.m_params.get(paramName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof SipHeaderValueImpl)) {
            return false;
        }
        SipHeaderValueImpl value = (SipHeaderValueImpl)obj;
        if (this.m_baseValue.equals(value.getBaseValue())) {
            Map<String, String> params = value.getParams();
            Map<String, String> map = this.m_params;
            synchronized (map) {
                Map<String, String> map2 = params;
                synchronized (map2) {
                    return ((Object)this.m_params).equals(params);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Map<String, String> map = this.m_params;
        synchronized (map) {
            return 17 * ((Object)this.m_params).hashCode() * this.m_baseValue.hashCode();
        }
    }

    public String toString() {
        return this.m_baseValue + " " + this.m_params;
    }
}

