/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.transaction.client;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.lastbamboo.common.offer.answer.OfferAnswerMessage;
import org.lastbamboo.common.offer.answer.OfferAnswerTransactionListener;
import org.lastbamboo.common.sip.stack.message.DoubleCrlfKeepAlive;
import org.lastbamboo.common.sip.stack.message.Invite;
import org.lastbamboo.common.sip.stack.message.Register;
import org.lastbamboo.common.sip.stack.message.RequestTimeoutResponse;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.SipMessageFactory;
import org.lastbamboo.common.sip.stack.message.SipResponse;
import org.lastbamboo.common.sip.stack.message.UnknownSipRequest;
import org.lastbamboo.common.sip.stack.transaction.client.SipClientTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipClientTransactionImpl
implements SipClientTransaction {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final SipMessage m_request;
    private long m_transactionTime = Long.MAX_VALUE;
    private final List<OfferAnswerTransactionListener> m_transactionListeners;
    private final long m_transactionStartTime;
    private final SipMessageFactory m_messageFactory;
    private volatile boolean m_timerBFired = false;
    private final TimerTask m_timerB;

    public SipClientTransactionImpl(SipMessage request, List<OfferAnswerTransactionListener> transactionListeners, SipMessageFactory messageFactory, Timer timer, int t1) {
        this.m_request = request;
        this.m_transactionListeners = transactionListeners;
        this.m_transactionStartTime = System.currentTimeMillis();
        this.m_messageFactory = messageFactory;
        this.m_timerB = new TimerTask(){

            @Override
            public void run() {
                SipClientTransactionImpl.this.m_log.warn("Timer B firing!!  The client transaction timed out for request: " + SipClientTransactionImpl.this.m_request);
                SipClientTransactionImpl.this.m_timerBFired = true;
                SipResponse timeout = SipClientTransactionImpl.this.m_messageFactory.createRequestTimeoutResponse(SipClientTransactionImpl.this.m_request);
                SipClientTransactionImpl.this.notifyListenersOfFailure(timeout);
            }
        };
        timer.schedule(this.m_timerB, 64 * t1);
    }

    @Override
    public void addListener(OfferAnswerTransactionListener listener) {
        this.m_transactionListeners.add(listener);
    }

    @Override
    public SipMessage getRequest() {
        return this.m_request;
    }

    @Override
    public long getTransactionTime() {
        return this.m_transactionTime;
    }

    @Override
    public void visitResponse(SipResponse response) {
        this.m_log.debug("SIP client transaction visiting response...");
        if (this.m_timerBFired) {
            this.m_log.warn("Received response after timer B fired!!");
            return;
        }
        this.m_log.debug("Canceling TIMER B");
        this.m_timerB.cancel();
        if (response.getStatusCode() == 200) {
            this.setTransactionTime();
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug("Transaction time: " + this.getTransactionTime());
            }
            for (OfferAnswerTransactionListener listener : this.m_transactionListeners) {
                listener.onTransactionSucceeded((OfferAnswerMessage)response);
            }
        } else {
            this.m_log.warn("Received non OK response: " + response.getStatusCode());
        }
    }

    @Override
    public void visitRequestTimedOut(RequestTimeoutResponse response) {
        if (this.m_timerBFired) {
            this.m_log.warn("Received OK after timer B fired!!");
            return;
        }
        this.m_timerB.cancel();
        this.notifyListenersOfFailure(response);
    }

    private void notifyListenersOfFailure(OfferAnswerMessage response) {
        this.setTransactionTime();
        for (OfferAnswerTransactionListener listener : this.m_transactionListeners) {
            listener.onTransactionFailed(response);
        }
    }

    private void setTransactionTime() {
        this.m_transactionTime = System.currentTimeMillis() - this.m_transactionStartTime;
    }

    @Override
    public void visitInvite(Invite invite) {
        this.m_log.warn("Should not receive invites on client transactions: " + invite);
    }

    @Override
    public void visitRegister(Register register) {
        this.m_log.warn("Should not receive registers on client transactions: " + register);
    }

    @Override
    public void visitUnknownRequest(UnknownSipRequest request) {
        this.m_log.warn("Should not receive unknown messages on client transactions: " + request);
    }

    @Override
    public void visitDoubleCrlfKeepAlive(DoubleCrlfKeepAlive keepAlive) {
        this.m_log.warn("Should not receive double CRLF keep alives on the client");
    }
}

