/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.transaction.client;

import java.util.ArrayList;
import java.util.Timer;
import org.lastbamboo.common.offer.answer.OfferAnswerTransactionListener;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.SipMessageFactory;
import org.lastbamboo.common.sip.stack.transaction.client.SipClientTransaction;
import org.lastbamboo.common.sip.stack.transaction.client.SipClientTransactionImpl;
import org.lastbamboo.common.sip.stack.transaction.client.SipTransactionFactory;
import org.lastbamboo.common.sip.stack.transaction.client.SipTransactionTracker;

public class SipTransactionFactoryImpl
implements SipTransactionFactory {
    private final SipTransactionTracker m_transactionTracker;
    private final SipMessageFactory m_messageFactory;
    private final Timer m_timerBThread;
    private final int m_t1;

    public SipTransactionFactoryImpl(SipTransactionTracker tracker, SipMessageFactory messageFactory, int t1) {
        this.m_transactionTracker = tracker;
        this.m_messageFactory = messageFactory;
        this.m_timerBThread = new Timer("SIP-TimerB-Thread", true);
        this.m_t1 = t1;
    }

    @Override
    public SipClientTransaction createClientTransaction(SipMessage request, OfferAnswerTransactionListener listener) {
        ArrayList<OfferAnswerTransactionListener> listeners = new ArrayList<OfferAnswerTransactionListener>();
        listeners.add(listener);
        SipClientTransactionImpl ct = new SipClientTransactionImpl(request, listeners, this.m_messageFactory, this.m_timerBThread, this.m_t1);
        this.m_transactionTracker.trackTransaction(ct);
        return ct;
    }
}

