/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.transaction.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.lastbamboo.common.offer.answer.OfferAnswerMessage;
import org.lastbamboo.common.offer.answer.OfferAnswerTransactionListener;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.transaction.client.SipClientTransaction;
import org.lastbamboo.common.sip.stack.transaction.client.SipTransactionTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SipTransactionTrackerImpl
implements SipTransactionTracker,
OfferAnswerTransactionListener {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, SipClientTransaction> m_transactions = new ConcurrentHashMap<String, SipClientTransaction>();

    @Override
    public void trackTransaction(SipClientTransaction ct) {
        this.m_log.debug("Tracking transaction...");
        SipMessage message = ct.getRequest();
        String key = message.getTransactionKey();
        this.m_transactions.put(key, ct);
        ct.addListener(this);
    }

    @Override
    public SipClientTransaction getClientTransaction(SipMessage message) {
        this.m_log.debug("Accessing client transaction...");
        String key = message.getTransactionKey();
        this.m_log.debug("Using key: " + key);
        if (StringUtils.isBlank((String)key)) {
            this.m_log.error("Blank key for message: " + message);
            throw new IllegalArgumentException("Bad message: " + message);
        }
        SipClientTransaction ct = this.m_transactions.get(key);
        if (ct == null) {
            this.m_log.warn("Nothing known about transaction: " + key);
            this.m_log.warn("Known transactions: " + this.m_transactions.keySet());
        }
        return ct;
    }

    public void onTransactionSucceeded(OfferAnswerMessage message) {
        this.removeTransaction(message);
    }

    public void onTransactionFailed(OfferAnswerMessage message) {
        this.removeTransaction(message);
    }

    private void removeTransaction(OfferAnswerMessage message) {
        String key = message.getTransactionKey();
        this.m_log.debug("Removing transaction with key '" + key + "'");
        SipClientTransaction removed = this.m_transactions.remove(key);
        if (removed == null) {
            this.m_log.warn("Could not find transaction!!");
        }
    }
}

