/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.transport;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.lastbamboo.common.offer.answer.OfferAnswerTransactionListener;
import org.lastbamboo.common.sip.stack.message.Invite;
import org.lastbamboo.common.sip.stack.message.Register;
import org.lastbamboo.common.sip.stack.message.SipMessage;
import org.lastbamboo.common.sip.stack.message.SipMessageFactory;
import org.lastbamboo.common.sip.stack.message.SipMessageUtils;
import org.lastbamboo.common.sip.stack.message.SipResponse;
import org.lastbamboo.common.sip.stack.message.header.SipHeader;
import org.lastbamboo.common.sip.stack.message.header.SipHeaderFactory;
import org.lastbamboo.common.sip.stack.transaction.client.SipClientTransaction;
import org.lastbamboo.common.sip.stack.transaction.client.SipTransactionFactory;
import org.lastbamboo.common.sip.stack.transport.SipTcpTransportLayer;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoFuture;
import org.littleshoot.mina.common.IoFutureListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.WriteFuture;
import org.littleshoot.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SipTcpTransportLayerImpl
implements SipTcpTransportLayer,
IoFutureListener {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final Map<InetSocketAddress, IoSession> m_socketAddressesToIo = new ConcurrentHashMap<InetSocketAddress, IoSession>();
    private final SipHeaderFactory m_headerFactory;
    private final SipTransactionFactory m_transactionFactory;
    private final SipMessageFactory m_messageFactory;

    public SipTcpTransportLayerImpl(SipTransactionFactory transactionFactory, SipHeaderFactory headerFactory, SipMessageFactory messageFactory) {
        this.m_transactionFactory = transactionFactory;
        this.m_headerFactory = headerFactory;
        this.m_messageFactory = messageFactory;
    }

    @Override
    public void addConnection(IoSession io) {
        InetSocketAddress remoteAddress = (InetSocketAddress)io.getRemoteAddress();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Adding connection for socket address: " + remoteAddress);
        }
        this.m_socketAddressesToIo.put(remoteAddress, io);
    }

    @Override
    public void removeConnection(IoSession io) {
        InetSocketAddress remoteAddress = (InetSocketAddress)io.getRemoteAddress();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Removing connection for socket address: " + remoteAddress);
        }
        this.m_socketAddressesToIo.remove(remoteAddress);
    }

    @Override
    public SipClientTransaction invite(Invite request, IoSession io, OfferAnswerTransactionListener transactionListener) {
        Invite viaAdded;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Writing request to: " + io);
        }
        try {
            viaAdded = this.addVia(request);
        }
        catch (UnknownHostException e) {
            this.LOG.error("Could not get local host", (Throwable)e);
            return null;
        }
        SipClientTransaction clientTransaction = this.m_transactionFactory.createClientTransaction(viaAdded, transactionListener);
        this.write(viaAdded, io, true);
        return clientTransaction;
    }

    @Override
    public SipClientTransaction register(Register request, IoSession io, OfferAnswerTransactionListener transactionListener) {
        Register viaAdded;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Writing request to: " + io);
        }
        try {
            viaAdded = this.addVia(request);
        }
        catch (UnknownHostException e) {
            this.LOG.error("Could not get local host", (Throwable)e);
            return null;
        }
        SipClientTransaction clientTransaction = this.m_transactionFactory.createClientTransaction(viaAdded, transactionListener);
        this.write(viaAdded, io, true);
        return clientTransaction;
    }

    @Override
    public void writeRequestStatelessly(Invite request, IoSession io) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Writing request statelessly...");
        }
        try {
            Invite viaAdded = this.addVia(request);
            this.write(viaAdded, io);
        }
        catch (UnknownHostException e) {
            this.LOG.error("Could not get local host", (Throwable)e);
        }
    }

    private Register addVia(Register request) throws UnknownHostException {
        InetAddress localHost = NetworkUtils.getLocalHost();
        SipHeader via = this.m_headerFactory.createSentByVia(localHost);
        return this.m_messageFactory.addVia(request, via);
    }

    private Invite addVia(Invite request) throws UnknownHostException {
        InetAddress localHost = NetworkUtils.getLocalHost();
        SipHeader via = this.m_headerFactory.createSentByVia(localHost);
        return this.m_messageFactory.addVia(request, via);
    }

    @Override
    public boolean writeResponse(InetSocketAddress socketAddress, SipResponse response) {
        IoSession io = this.m_socketAddressesToIo.get(socketAddress);
        if (io == null) {
            this.writeDebugData(socketAddress);
            return false;
        }
        this.write(response, io);
        return true;
    }

    private void write(SipMessage message, IoSession io) {
        this.write(message, io, true);
    }

    private void write(SipMessage message, IoSession io, boolean listen) {
        WriteFuture wf = io.write((Object)message);
        if (listen) {
            wf.addListener((IoFutureListener)this);
        }
    }

    @Override
    public WriteFuture writeCrlfKeepAlive(IoSession io) {
        ByteBuffer buf;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Writing double CRLF");
        }
        String doubleCrlf = "\r\n\r\n";
        try {
            buf = ByteBuffer.wrap((byte[])"\r\n\r\n".getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            this.LOG.error("Bad encoding??", (Throwable)e);
            return null;
        }
        return io.write((Object)buf);
    }

    @Override
    public void writeResponse(SipResponse response) throws IOException {
        InetSocketAddress nextHop = SipMessageUtils.extractNextHopFromVia(response);
        this.writeResponse(nextHop, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasConnectionForAny(Collection<InetSocketAddress> socketAddresses) {
        Map<InetSocketAddress, IoSession> map = this.m_socketAddressesToIo;
        synchronized (map) {
            Set<InetSocketAddress> existingAddresses = this.m_socketAddressesToIo.keySet();
            return CollectionUtils.containsAny(existingAddresses, socketAddresses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRequest(Collection<InetSocketAddress> socketAddresses, Invite request) {
        Map<InetSocketAddress, IoSession> map = this.m_socketAddressesToIo;
        synchronized (map) {
            Iterator i$;
            Set<InetSocketAddress> existingAddresses = this.m_socketAddressesToIo.keySet();
            Collection intersection = CollectionUtils.intersection(existingAddresses, socketAddresses);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Found " + intersection.size() + " matching connections...");
            }
            if ((i$ = intersection.iterator()).hasNext()) {
                InetSocketAddress socketAddress = (InetSocketAddress)i$.next();
                IoSession io = this.m_socketAddressesToIo.get(socketAddress);
                this.writeRequestStatelessly(request, io);
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("Sent request to: " + io);
                }
                return;
            }
        }
    }

    public void operationComplete(IoFuture future) {
        if (this.LOG.isDebugEnabled()) {
            IoSession sess = future.getSession();
            this.LOG.debug("Wrote messages: " + sess.getWrittenMessages() + " on session " + sess);
        }
    }

    private void writeDebugData(InetSocketAddress socketAddress) {
        this.LOG.warn("No connection for socket address: " + socketAddress);
        this.LOG.warn("hashCode(): " + socketAddress.hashCode());
        if (this.m_socketAddressesToIo.size() < 10) {
            this.LOG.warn("Existing connections: " + this.m_socketAddressesToIo);
            StringBuilder sb = new StringBuilder();
            Set<InetSocketAddress> keys = this.m_socketAddressesToIo.keySet();
            for (InetSocketAddress sa : keys) {
                sb.append(sa.toString());
                sb.append(" code: ");
                sb.append(sa.hashCode());
                sb.append(", ");
            }
            this.LOG.warn("hashCode()s: " + sb.toString());
        }
    }
}

