/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.sip.stack.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.lastbamboo.common.sip.stack.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriUtilsImpl
implements UriUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UriUtilsImpl.class);
    private final String m_sipUriPortRegex = "[sips:|sip:]\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}:(\\d+)";
    private final Pattern m_sipUriPortPattern = Pattern.compile("[sips:|sip:]\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}:(\\d+)");

    @Override
    public URI getUri(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new RuntimeException(uriSyntaxException);
        }
    }

    @Override
    public URI getUriForHost(String host) {
        try {
            return new URI(null, host, null, null);
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new RuntimeException(uriSyntaxException);
        }
    }

    @Override
    public URI getSipUri(String host) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("sip:");
        buffer.append(host);
        try {
            return new URI(buffer.toString());
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new RuntimeException(uriSyntaxException);
        }
    }

    @Override
    public URI getSipUri(String host, int port) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("sip:");
        buffer.append(host);
        buffer.append(':');
        buffer.append(port);
        try {
            return new URI(buffer.toString());
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new RuntimeException(uriSyntaxException);
        }
    }

    @Override
    public URI getSipUri(String host, int port, String transport) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("sip:");
        buffer.append(host);
        buffer.append(':');
        buffer.append(port);
        buffer.append(';');
        buffer.append("transport=");
        buffer.append(transport);
        try {
            return new URI(buffer.toString());
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new RuntimeException(uriSyntaxException);
        }
    }

    @Override
    public URI getUriWithPort(URI uri, int port) {
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException uriSyntaxException) {
            throw new RuntimeException(uriSyntaxException);
        }
    }

    @Override
    public String getUserInSipUri(URI sipUri) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting user for URI: " + sipUri);
        }
        String sipUriString = sipUri.toASCIIString();
        return StringUtils.substringBetween((String)sipUriString, (String)"sip:", (String)"@");
    }

    @Override
    public String getHostInSipUri(URI sipUri) {
        String uri = sipUri.toASCIIString();
        LOG.debug("Parsing URI string: " + uri);
        String candidate1 = StringUtils.substringBetween((String)uri, (String)"sip:", (String)":");
        LOG.debug("Candidate 1: " + candidate1);
        if (!StringUtils.isBlank((String)candidate1)) {
            return candidate1;
        }
        String candidate2 = StringUtils.substringBetween((String)uri, (String)"sip:", (String)";");
        LOG.debug("Cadidate 2: " + candidate2);
        if (!StringUtils.isBlank((String)candidate2)) {
            return candidate2;
        }
        return StringUtils.substringAfterLast((String)uri, (String)"@");
    }

    @Override
    public int getPersonIdInSipUri(URI sipUri) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting person ID for URI: " + sipUri);
        }
        return Integer.parseInt(this.getUserInSipUri(sipUri));
    }

    @Override
    public int getPortInSipUri(URI uri) {
        String uriString = uri.toASCIIString();
        LOG.debug("Getting port from URI: " + uriString);
        Matcher matcher = this.m_sipUriPortPattern.matcher(uriString);
        if (matcher.find()) {
            String port = matcher.group(1);
            LOG.debug("Found port: " + port);
            return Integer.parseInt(port);
        }
        if (uriString.startsWith("sips:")) {
            return 5061;
        }
        return 5060;
    }
}

