/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.util.Base64;

public abstract class SASLMechanism
implements CallbackHandler {
    private SASLAuthentication saslAuthentication;
    protected SaslClient sc;
    protected String authenticationId;
    protected String password;
    protected String hostname;

    public SASLMechanism(SASLAuthentication saslAuthentication) {
        this.saslAuthentication = saslAuthentication;
    }

    public void authenticate(String username, String host, String password) throws IOException, XMPPException {
        this.authenticationId = username;
        this.password = password;
        this.hostname = host;
        String[] mechanisms = new String[]{this.getName()};
        HashMap props = new HashMap();
        this.sc = Sasl.createSaslClient(mechanisms, username, "xmpp", host, props, this);
        this.authenticate();
    }

    public void authenticate(String username, String host, CallbackHandler cbh) throws IOException, XMPPException {
        String[] mechanisms = new String[]{this.getName()};
        HashMap props = new HashMap();
        this.sc = Sasl.createSaslClient(mechanisms, username, "xmpp", host, props, cbh);
        this.authenticate();
    }

    protected void authenticate() throws IOException, XMPPException {
        StringBuilder stanza = new StringBuilder();
        stanza.append("<auth mechanism=\"").append(this.getName());
        stanza.append("\" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
        try {
            byte[] response;
            String authenticationText;
            if (this.sc.hasInitialResponse() && (authenticationText = Base64.encodeBytes(response = this.sc.evaluateChallenge(new byte[0]), 8)) != null && !authenticationText.equals("")) {
                stanza.append(authenticationText);
            }
        }
        catch (SaslException e) {
            throw new XMPPException("SASL authentication failed", e);
        }
        stanza.append("</auth>");
        this.getSASLAuthentication().send(stanza.toString());
    }

    public void challengeReceived(String challenge) throws IOException {
        StringBuilder stanza = new StringBuilder();
        byte[] response = challenge != null ? this.sc.evaluateChallenge(Base64.decode(challenge)) : this.sc.evaluateChallenge(null);
        String authenticationText = Base64.encodeBytes(response, 8);
        if (authenticationText.equals("")) {
            authenticationText = "=";
        }
        stanza.append("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
        stanza.append(authenticationText);
        stanza.append("</response>");
        this.getSASLAuthentication().send(stanza.toString());
    }

    protected abstract String getName();

    protected SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback ncb = (NameCallback)callbacks[i];
                ncb.setName(this.authenticationId);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pcb = (PasswordCallback)callbacks[i];
                pcb.setPassword(this.password.toCharArray());
                continue;
            }
            if (callbacks[i] instanceof RealmCallback) {
                RealmCallback rcb = (RealmCallback)callbacks[i];
                rcb.setText(this.hostname);
                continue;
            }
            if (callbacks[i] instanceof RealmChoiceCallback) continue;
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }
}

