/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.packet.AdHocCommandData;

public class RemoteCommand
extends AdHocCommand {
    private XMPPConnection connection;
    private String jid;
    private String sessionID;

    protected RemoteCommand(XMPPConnection connection, String node, String jid) {
        this.connection = connection;
        this.jid = jid;
        this.setNode(node);
    }

    @Override
    public void cancel() throws XMPPException {
        this.executeAction(AdHocCommand.Action.cancel);
    }

    @Override
    public void complete(Form form) throws XMPPException {
        this.executeAction(AdHocCommand.Action.complete, form);
    }

    @Override
    public void execute() throws XMPPException {
        this.executeAction(AdHocCommand.Action.execute);
    }

    public void execute(Form form) throws XMPPException {
        this.executeAction(AdHocCommand.Action.execute, form);
    }

    @Override
    public void next(Form form) throws XMPPException {
        this.executeAction(AdHocCommand.Action.next, form);
    }

    @Override
    public void prev() throws XMPPException {
        this.executeAction(AdHocCommand.Action.prev);
    }

    private void executeAction(AdHocCommand.Action action) throws XMPPException {
        this.executeAction(action, null);
    }

    private void executeAction(AdHocCommand.Action action, Form form) throws XMPPException {
        AdHocCommandData data = new AdHocCommandData();
        data.setType(IQ.Type.SET);
        data.setTo(this.getOwnerJID());
        data.setNode(this.getNode());
        data.setSessionID(this.sessionID);
        data.setAction(action);
        if (form != null) {
            data.setForm(form.getDataFormToSend());
        }
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(data.getPacketID()));
        this.connection.sendPacket(data);
        Packet response = collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (response == null) {
            throw new XMPPException("No response from server on status set.");
        }
        if (response.getError() != null) {
            throw new XMPPException(response.getError());
        }
        AdHocCommandData responseData = (AdHocCommandData)response;
        this.sessionID = responseData.getSessionID();
        super.setData(responseData);
    }

    @Override
    public String getOwnerJID() {
        return this.jid;
    }
}

