/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromContainsFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;
import org.jivesoftware.smackx.packet.IBBExtensions;
import org.jivesoftware.smackx.packet.StreamInitiation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBBTransferNegotiator
extends StreamNegotiator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected static final String NAMESPACE = "http://jabber.org/protocol/ibb";
    public static final int DEFAULT_BLOCK_SIZE = 4096;
    private XMPPConnection connection;

    protected IBBTransferNegotiator(XMPPConnection connection) {
        this.connection = connection;
    }

    @Override
    public PacketFilter getInitiationPacketFilter(String from, String streamID) {
        return new AndFilter(new FromContainsFilter(from), new IBBOpenSidFilter(streamID));
    }

    @Override
    InputStream negotiateIncomingStream(Packet streamInitiation) throws XMPPException {
        IBBExtensions.Open openRequest = (IBBExtensions.Open)streamInitiation;
        if (openRequest.getType().equals(IQ.Type.ERROR)) {
            throw new XMPPException(openRequest.getError());
        }
        IBBMessageSidFilter dataFilter = new IBBMessageSidFilter(openRequest.getFrom(), openRequest.getSessionID());
        AndFilter closeFilter = new AndFilter(new PacketTypeFilter(IBBExtensions.Close.class), new FromMatchesFilter(openRequest.getFrom()));
        IBBInputStream stream = new IBBInputStream(openRequest.getSessionID(), dataFilter, closeFilter);
        this.initInBandTransfer(openRequest);
        return stream;
    }

    @Override
    public InputStream createIncomingStream(StreamInitiation initiation) throws XMPPException {
        Packet openRequest = this.initiateIncomingStream(this.connection, initiation);
        return this.negotiateIncomingStream(openRequest);
    }

    private void initInBandTransfer(IBBExtensions.Open openRequest) {
        this.connection.sendPacket(FileTransferNegotiator.createIQ(openRequest.getPacketID(), openRequest.getFrom(), openRequest.getTo(), IQ.Type.RESULT));
    }

    @Override
    public OutputStream createOutgoingStream(String streamID, String initiator, String target) throws XMPPException {
        IBBExtensions.Open openIQ = new IBBExtensions.Open(streamID, 4096);
        openIQ.setTo(target);
        openIQ.setType(IQ.Type.SET);
        PacketCollector collector = this.connection.createPacketCollector(new PacketIDFilter(openIQ.getPacketID()));
        this.connection.sendPacket(openIQ);
        IQ openResponse = (IQ)collector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        collector.cancel();
        if (openResponse == null) {
            throw new XMPPException("No response from peer on IBB open");
        }
        IQ.Type type = openResponse.getType();
        if (!type.equals(IQ.Type.RESULT)) {
            if (type.equals(IQ.Type.ERROR)) {
                throw new XMPPException("Target returned an error", openResponse.getError());
            }
            throw new XMPPException("Target returned unknown response");
        }
        return new IBBOutputStream(target, streamID, 4096);
    }

    @Override
    public String[] getNamespaces() {
        return new String[]{NAMESPACE};
    }

    @Override
    public void cleanup() {
    }

    private static class IBBMessageSidFilter
    implements PacketFilter {
        private final String sessionID;
        private String from;

        public IBBMessageSidFilter(String from, String sessionID) {
            this.from = from;
            this.sessionID = sessionID;
        }

        @Override
        public boolean accept(Packet packet) {
            if (!(packet instanceof Message)) {
                return false;
            }
            if (!packet.getFrom().equalsIgnoreCase(this.from)) {
                return false;
            }
            IBBExtensions.Data data = (IBBExtensions.Data)packet.getExtension("data", IBBTransferNegotiator.NAMESPACE);
            return data != null && data.getSessionID() != null && data.getSessionID().equalsIgnoreCase(this.sessionID);
        }
    }

    private static class IBBOpenSidFilter
    implements PacketFilter {
        private String sessionID;

        public IBBOpenSidFilter(String sessionID) {
            if (sessionID == null) {
                throw new IllegalArgumentException("StreamID cannot be null");
            }
            this.sessionID = sessionID;
        }

        @Override
        public boolean accept(Packet packet) {
            if (!IBBExtensions.Open.class.isInstance(packet)) {
                return false;
            }
            IBBExtensions.Open open = (IBBExtensions.Open)packet;
            String sessionID = open.getSessionID();
            return sessionID != null && sessionID.equals(this.sessionID);
        }
    }

    private class IBBInputStream
    extends InputStream
    implements PacketListener {
        private String streamID;
        private PacketCollector dataCollector;
        private byte[] buffer;
        private int bufferPointer;
        private long inputStreamSeq = -1L;
        private boolean isDone;
        private boolean isEOF;
        private boolean isClosed;
        private IQ closeConfirmation;
        private Message lastMess;
        private Map<Long, Message> outOfSequenceMessages = new HashMap<Long, Message>();

        private IBBInputStream(String streamID, PacketFilter dataFilter, PacketFilter closeFilter) {
            this.streamID = streamID;
            this.dataCollector = IBBTransferNegotiator.this.connection.createPacketCollector(dataFilter);
            IBBTransferNegotiator.this.connection.addPacketListener(this, closeFilter);
            this.bufferPointer = -1;
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.isEOF || this.isClosed) {
                return -1;
            }
            if (this.bufferPointer == -1 || this.bufferPointer >= this.buffer.length) {
                this.loadBufferWait();
            }
            return this.buffer[this.bufferPointer++];
        }

        @Override
        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (this.isEOF || this.isClosed) {
                return -1;
            }
            if (!(this.bufferPointer != -1 && this.bufferPointer < this.buffer.length || this.loadBufferWait())) {
                this.isEOF = true;
                return -1;
            }
            if (len - off > this.buffer.length - this.bufferPointer) {
                len = this.buffer.length - this.bufferPointer;
            }
            System.arraycopy(this.buffer, this.bufferPointer, b, off, len);
            this.bufferPointer += len;
            return len;
        }

        private boolean loadBufferWait() throws IOException {
            if (this.inputStreamSeq == 65535L) {
                IBBTransferNegotiator.this.log.warn("MAX SEQUENCE NUMBER??");
                this.inputStreamSeq = -1L;
            }
            IBBExtensions.Data data = null;
            Message mess = null;
            if (this.outOfSequenceMessages.containsKey(this.inputStreamSeq + 1L)) {
                mess = this.outOfSequenceMessages.remove(this.inputStreamSeq + 1L);
                data = (IBBExtensions.Data)mess.getExtension("data", IBBTransferNegotiator.NAMESPACE);
                IBBTransferNegotiator.this.log.info("USING MAPPED SEQUENCE NUMBER: " + this.inputStreamSeq);
            } else {
                while (mess == null || data == null) {
                    Message tempMessage;
                    if (this.isDone) {
                        tempMessage = (Message)this.dataCollector.pollResult();
                        if (tempMessage == null) {
                            return false;
                        }
                    } else {
                        tempMessage = (Message)this.dataCollector.nextResult(1000L);
                    }
                    if (tempMessage == null) continue;
                    IBBExtensions.Data tempData = (IBBExtensions.Data)tempMessage.getExtension("data", IBBTransferNegotiator.NAMESPACE);
                    if (tempData != null) {
                        mess = tempMessage;
                        data = tempData;
                        continue;
                    }
                    IBBTransferNegotiator.this.log.info("Received a non-data message: {}", (Object)tempMessage);
                }
            }
            long seq = data.getSeq();
            if (seq - 1L != this.inputStreamSeq) {
                IBBTransferNegotiator.this.log.info("ADDING OUT OF ORDER SEQUENCE NUMBER: " + seq);
                this.outOfSequenceMessages.put(seq, mess);
                if (this.outOfSequenceMessages.size() > 1000) {
                    this.outOfSequenceMessages.clear();
                    String msg = "Received max out of sequence msgs";
                    IBBTransferNegotiator.this.log.info("Received max out of sequence msgs");
                    throw new IOException("Received max out of sequence msgs");
                }
                return this.loadBufferWait();
            }
            Message toUse = mess;
            this.inputStreamSeq = seq;
            this.lastMess = toUse;
            this.buffer = StringUtils.decodeBase64(data.getData());
            this.bufferPointer = 0;
            return true;
        }

        private void cancelTransfer(Message mess) {
            this.cleanup();
            this.sendCancelMessage(mess);
        }

        private void cleanup() {
            this.dataCollector.cancel();
            IBBTransferNegotiator.this.connection.removePacketListener(this);
        }

        private void sendCancelMessage(Message message) {
            IQ error = FileTransferNegotiator.createIQ(message.getPacketID(), message.getFrom(), message.getTo(), IQ.Type.ERROR);
            error.setError(new XMPPError(XMPPError.Condition.remote_server_timeout, "Cancel Message Transfer"));
            IBBTransferNegotiator.this.connection.sendPacket(error);
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void processPacket(Packet packet) {
            IBBExtensions.Close close = (IBBExtensions.Close)packet;
            if (close.getSessionID().equals(this.streamID)) {
                this.isDone = true;
                this.closeConfirmation = FileTransferNegotiator.createIQ(packet.getPacketID(), packet.getFrom(), packet.getTo(), IQ.Type.RESULT);
            }
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            this.cleanup();
            if (this.isEOF) {
                this.sendCloseConfirmation();
            } else if (this.lastMess != null) {
                this.sendCancelMessage(this.lastMess);
            }
            this.isClosed = true;
        }

        private void sendCloseConfirmation() {
            IBBTransferNegotiator.this.connection.sendPacket(this.closeConfirmation);
        }
    }

    private class IBBOutputStream
    extends OutputStream {
        protected byte[] buffer;
        protected int count = 0;
        protected long outputStreamSeq = 0L;
        final String userID;
        private final IQ closePacket;
        private String messageID;
        private String sid;

        IBBOutputStream(String userID, String sid, int blockSize) {
            if (blockSize <= 0) {
                throw new IllegalArgumentException("Buffer size <= 0");
            }
            this.buffer = new byte[blockSize];
            this.userID = userID;
            Message template = new Message(userID);
            this.messageID = template.getPacketID();
            this.sid = sid;
            this.closePacket = this.createClosePacket(userID, sid);
        }

        private IQ createClosePacket(String userID, String sid) {
            IBBExtensions.Close packet = new IBBExtensions.Close(sid);
            packet.setTo(userID);
            packet.setType(IQ.Type.SET);
            return packet;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.count >= this.buffer.length) {
                this.flushBuffer();
            }
            this.buffer[this.count++] = (byte)b;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (len >= this.buffer.length) {
                this.writeOut(b, off, this.buffer.length);
                this.write(b, off + this.buffer.length, len - this.buffer.length);
            } else {
                this.writeOut(b, off, len);
            }
        }

        private void writeOut(byte[] b, int off, int len) {
            if (len > this.buffer.length - this.count) {
                this.flushBuffer();
            }
            System.arraycopy(b, off, this.buffer, this.count, len);
            this.count += len;
        }

        private synchronized void flushBuffer() {
            this.writeToXML(this.buffer, 0, this.count);
            this.count = 0;
        }

        private synchronized void writeToXML(byte[] buffer, int offset, int len) {
            Message template = this.createTemplate(this.messageID + "_" + this.outputStreamSeq);
            IBBExtensions.Data ext = new IBBExtensions.Data(this.sid);
            template.addExtension(ext);
            String enc = StringUtils.encodeBase64(buffer, offset, len, false);
            ext.setData(enc);
            ext.setSeq(this.outputStreamSeq);
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            IBBTransferNegotiator.this.connection.sendPacket(template);
            this.outputStreamSeq = this.outputStreamSeq + 1L == 65535L ? 0L : this.outputStreamSeq + 1L;
        }

        @Override
        public void close() throws IOException {
            this.flush();
            IBBTransferNegotiator.this.connection.sendPacket(this.closePacket);
        }

        @Override
        public void flush() throws IOException {
            this.flushBuffer();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public Message createTemplate(String messageID) {
            Message template = new Message(this.userID);
            template.setPacketID(messageID);
            return template;
        }
    }
}

