/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smackx.workgroup.agent.WorkgroupQueue;
import org.xmlpull.v1.XmlPullParser;

public class QueueOverview
implements PacketExtension {
    public static String ELEMENT_NAME = "notify-queue";
    public static String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private int averageWaitTime = -1;
    private Date oldestEntry = null;
    private int userCount = -1;
    private WorkgroupQueue.Status status = null;

    QueueOverview() {
    }

    void setAverageWaitTime(int averageWaitTime) {
        this.averageWaitTime = averageWaitTime;
    }

    public int getAverageWaitTime() {
        return this.averageWaitTime;
    }

    void setOldestEntry(Date oldestEntry) {
        this.oldestEntry = oldestEntry;
    }

    public Date getOldestEntry() {
        return this.oldestEntry;
    }

    void setUserCount(int userCount) {
        this.userCount = userCount;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public WorkgroupQueue.Status getStatus() {
        return this.status;
    }

    void setStatus(WorkgroupQueue.Status status) {
        this.status = status;
    }

    @Override
    public String getElementName() {
        return ELEMENT_NAME;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\">");
        if (this.userCount != -1) {
            buf.append("<count>").append(this.userCount).append("</count>");
        }
        if (this.oldestEntry != null) {
            buf.append("<oldest>").append(DATE_FORMATTER.format(this.oldestEntry)).append("</oldest>");
        }
        if (this.averageWaitTime != -1) {
            buf.append("<time>").append(this.averageWaitTime).append("</time>");
        }
        if (this.status != null) {
            buf.append("<status>").append(this.status).append("</status>");
        }
        buf.append("</").append(ELEMENT_NAME).append(">");
        return buf.toString();
    }

    public static class Provider
    implements PacketExtensionProvider {
        @Override
        public PacketExtension parseExtension(XmlPullParser parser) throws Exception {
            int eventType = parser.getEventType();
            QueueOverview queueOverview = new QueueOverview();
            if (eventType != 2) {
                // empty if block
            }
            eventType = parser.next();
            while (eventType != 3 || !ELEMENT_NAME.equals(parser.getName())) {
                if ("count".equals(parser.getName())) {
                    queueOverview.setUserCount(Integer.parseInt(parser.nextText()));
                } else if ("time".equals(parser.getName())) {
                    queueOverview.setAverageWaitTime(Integer.parseInt(parser.nextText()));
                } else if ("oldest".equals(parser.getName())) {
                    queueOverview.setOldestEntry(DATE_FORMATTER.parse(parser.nextText()));
                } else if ("status".equals(parser.getName())) {
                    queueOverview.setStatus(WorkgroupQueue.Status.fromString(parser.nextText()));
                }
                if ((eventType = parser.next()) == 3) continue;
            }
            if (eventType != 3) {
                // empty if block
            }
            return queueOverview;
        }
    }
}

