/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.stun.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.lastbamboo.common.stun.server.StunServer;
import org.lastbamboo.common.stun.server.UdpStunServer;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ByteBufferAllocator;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.SimpleByteBufferAllocator;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStunServer
implements StunServer,
IoServiceListener {
    private static final Logger LOG = LoggerFactory.getLogger(UdpStunServer.class);
    private static final int STUN_PORT = 3478;
    private InetSocketAddress boundAddress;
    protected final String threadName;
    protected final ProtocolCodecFactory codecFactory;
    protected final IoHandler ioHandler;

    public AbstractStunServer(ProtocolCodecFactory codecFactory, IoHandler ioHandler, String threadName) {
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        this.codecFactory = codecFactory;
        this.ioHandler = ioHandler;
        this.threadName = threadName;
    }

    @Override
    public void start() throws IOException {
        this.start(new InetSocketAddress(NetworkUtils.getLocalHost(), 3478));
    }

    @Override
    public void start(InetSocketAddress bindAddress) throws IOException {
        InetSocketAddress bindAddressToUse = AbstractStunServer.createBindAddress(bindAddress);
        this.bind(bindAddressToUse);
    }

    protected abstract void bind(InetSocketAddress var1) throws IOException;

    private static InetSocketAddress createBindAddress(InetSocketAddress bindAddress) {
        if (bindAddress == null) {
            try {
                return new InetSocketAddress(NetworkUtils.getLocalHost(), 0);
            }
            catch (UnknownHostException e) {
                LOG.warn("Could not get local host address", (Throwable)e);
                return null;
            }
        }
        return bindAddress;
    }

    @Override
    public InetSocketAddress getBoundAddress() {
        return this.boundAddress;
    }

    public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        LOG.debug("Setting bound address to: {}", (Object)serviceAddress);
        this.boundAddress = (InetSocketAddress)serviceAddress;
    }

    public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        LOG.debug("Session deactivated on service address: {}", (Object)serviceAddress);
    }

    public void sessionCreated(IoSession session) {
        LOG.debug("Session created: {}", (Object)session);
    }

    public void sessionDestroyed(IoSession session) {
        LOG.debug("Session destroyed: {}", (Object)session);
    }
}

