/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.stun.server;

import java.io.IOException;
import org.lastbamboo.common.stun.server.StunServerMessageVisitorFactory;
import org.lastbamboo.common.stun.server.UdpStunServer;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ByteBufferAllocator;
import org.littleshoot.mina.common.SimpleByteBufferAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunServerLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(StunServerLauncher.class);

    public static void main(String[] args) {
        LOG.debug("Launching SIP and TURN servers...");
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        StunServerLauncher launcher = new StunServerLauncher();
        LOG.debug("Created launcher");
        try {
            launcher.launch();
            LOG.debug("Started launcher");
        }
        catch (IOException e) {
            LOG.error("Could not start!!!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch() throws IOException {
        StunServerMessageVisitorFactory messageVisitorFactory = new StunServerMessageVisitorFactory();
        UdpStunServer server = new UdpStunServer(messageVisitorFactory, "UDP-STUN-Server");
        server.start();
        try {
            StunServerLauncher stunServerLauncher = this;
            synchronized (stunServerLauncher) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Got interrupt -- CTR-Ced?", (Throwable)e);
        }
    }
}

