/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.stun.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.lastbamboo.common.stun.server.AbstractStunServer;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.util.mina.MinaTcpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpStunServer
extends AbstractStunServer {
    private final Logger m_log = LoggerFactory.getLogger(TcpStunServer.class);
    private final MinaTcpServer m_server;

    public TcpStunServer(ProtocolCodecFactory codecFactory, IoHandler ioHandler, String threadName) {
        super(codecFactory, ioHandler, threadName);
        this.m_server = new MinaTcpServer(codecFactory, (IoServiceListener)this, ioHandler, "TCP-STUN-Server-" + threadName);
    }

    @Override
    protected void bind(InetSocketAddress bindAddress) throws IOException {
        this.m_log.debug("Running STUN TCP server on: {}", (Object)bindAddress);
        this.m_server.start(bindAddress.getPort());
    }

    @Override
    public void addIoServiceListener(IoServiceListener serviceListener) {
        this.m_server.addIoServiceListener(serviceListener);
    }

    @Override
    public void close() {
        this.m_server.stop();
    }
}

