/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.decoder;

import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.stun.stack.decoder.StunMessageDecodingState;
import org.littleshoot.util.mina.DecodingStateMachine;
import org.littleshoot.util.mina.DemuxableDecoderFactory;
import org.littleshoot.util.mina.DemuxableProtocolDecoder;
import org.littleshoot.util.mina.DemuxingStateMachineProtocolDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunDemuxableDecoderFactory
implements DemuxableDecoderFactory {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecode(ByteBuffer in) {
        int pos = in.position();
        int limit = in.limit();
        try {
            short firstByte = in.getUnsigned();
            int masked = firstByte & 0xC0;
            if (masked > 0) {
                boolean bl = false;
                return bl;
            }
            long magicCookie = 554869826L;
            long secondFourBytes = in.getUnsignedInt(pos + 4);
            boolean magicCookieMatches = secondFourBytes == 554869826L;
            this.m_log.debug("Magic cookie matches: " + magicCookieMatches);
            boolean bl = magicCookieMatches;
            return bl;
        }
        finally {
            in.position(pos);
            in.limit(limit);
        }
    }

    public DemuxableProtocolDecoder newDecoder() {
        StunMessageDecodingState startState = new StunMessageDecodingState();
        return new DemuxingStateMachineProtocolDecoder((DecodingStateMachine)startState);
    }

    public String toString() {
        return "STUN Decoder Factory";
    }
}

