/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.encoder;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.stun.stack.message.attributes.ErrorCodeAttribute;
import org.littleshoot.stun.stack.message.attributes.MappedAddressAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAddressAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeVisitor;
import org.littleshoot.stun.stack.message.attributes.ice.IceControlledAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IceControllingAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IcePriorityAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IceUseCandidateAttribute;
import org.littleshoot.stun.stack.message.attributes.turn.ConnectionStatus;
import org.littleshoot.stun.stack.message.attributes.turn.ConnectionStatusAttribute;
import org.littleshoot.stun.stack.message.attributes.turn.DataAttribute;
import org.littleshoot.stun.stack.message.attributes.turn.RelayAddressAttribute;
import org.littleshoot.stun.stack.message.attributes.turn.RemoteAddressAttribute;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunAttributeEncoder
implements StunAttributeVisitor {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final CharsetEncoder UTF_8_ENCODER = Charset.forName("UTF-8").newEncoder();
    private final ByteBuffer m_buf;

    public StunAttributeEncoder(ByteBuffer buf) {
        this.m_buf = buf;
    }

    @Override
    public void visitData(DataAttribute data) {
        this.writeHeader(data);
        byte[] dataBytes = data.getData();
        this.m_buf.put(dataBytes);
    }

    @Override
    public void visitConnectionStatus(ConnectionStatusAttribute attribute) {
        this.LOG.debug("Writing connection status attribute: {}", (Object)attribute);
        this.writeHeader(attribute);
        ConnectionStatus status = attribute.getConnectionStatus();
        MinaUtils.putUnsignedInt((ByteBuffer)this.m_buf, (long)status.toLong());
    }

    @Override
    public void visitIceControlled(IceControlledAttribute attribute) {
        this.writeHeader(attribute);
        byte[] tieBreaker = attribute.getTieBreaker();
        this.LOG.debug("Encoding controlled: {}", (Object)tieBreaker);
        this.m_buf.put(tieBreaker);
    }

    @Override
    public void visitIceControlling(IceControllingAttribute attribute) {
        this.writeHeader(attribute);
        byte[] tieBreaker = attribute.getTieBreaker();
        this.LOG.debug("Encoding controlling: {}", (Object)tieBreaker);
        this.m_buf.put(tieBreaker);
    }

    @Override
    public void visitIcePriority(IcePriorityAttribute attribute) {
        this.writeHeader(attribute);
        long priority = attribute.getPriority();
        MinaUtils.putUnsignedInt((ByteBuffer)this.m_buf, (long)priority);
    }

    @Override
    public void visitIceUseCandidate(IceUseCandidateAttribute attribute) {
        this.writeHeader(attribute);
    }

    @Override
    public void visiteErrorCode(ErrorCodeAttribute attribute) {
        this.writeHeader(attribute);
        this.m_buf.skip(2);
        MinaUtils.putUnsignedByte((ByteBuffer)this.m_buf, (int)attribute.getErrorClass());
        MinaUtils.putUnsignedByte((ByteBuffer)this.m_buf, (int)attribute.getErrorNumber());
        try {
            this.m_buf.putString(attribute.getReasonPhrase(), UTF_8_ENCODER);
        }
        catch (CharacterCodingException e) {
            this.LOG.error("Could not encode reason phrase", (Throwable)e);
            throw new IllegalArgumentException("Could not encode reason phrase", e);
        }
    }

    @Override
    public void visitRelayAddress(RelayAddressAttribute address) {
        this.visitAddressAttribute(address);
    }

    @Override
    public void visitMappedAddress(MappedAddressAttribute address) {
        this.visitAddressAttribute(address);
    }

    @Override
    public void visitRemoteAddress(RemoteAddressAttribute address) {
        this.visitAddressAttribute(address);
    }

    private void visitAddressAttribute(StunAddressAttribute address) {
        this.writeHeader(address);
        MinaUtils.putUnsignedByte((ByteBuffer)this.m_buf, (int)0);
        int family = address.getAddressFamily();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Writing family: " + family);
        }
        InetSocketAddress socketAddress = address.getInetSocketAddress();
        int port = socketAddress.getPort();
        InetAddress ia = socketAddress.getAddress();
        byte[] addressBytes = ia.getAddress();
        MinaUtils.putUnsignedByte((ByteBuffer)this.m_buf, (int)family);
        MinaUtils.putUnsignedShort((ByteBuffer)this.m_buf, (int)port);
        this.m_buf.put(addressBytes);
    }

    private void writeHeader(StunAttribute sa) {
        MinaUtils.putUnsignedShort((ByteBuffer)this.m_buf, (int)sa.getAttributeType().toInt());
        MinaUtils.putUnsignedShort((ByteBuffer)this.m_buf, (int)sa.getBodyLength());
    }
}

