/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.encoder;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.stun.stack.encoder.StunAttributeEncoder;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageType;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunMessageEncoder {
    private final Logger m_log = LoggerFactory.getLogger(StunMessageEncoder.class);

    public ByteBuffer encode(StunMessage stunMessage) {
        int length = stunMessage.getTotalLength();
        ByteBuffer buf = ByteBuffer.allocate((int)length);
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("Total message length: " + length + " for STUN message: " + stunMessage);
        }
        StunMessageType type = stunMessage.getType();
        MinaUtils.putUnsignedShort((ByteBuffer)buf, (int)type.toInt());
        MinaUtils.putUnsignedShort((ByteBuffer)buf, (int)stunMessage.getBodyLength());
        UUID transactionId = stunMessage.getTransactionId();
        buf.put(transactionId.getRawBytes());
        Map<StunAttributeType, StunAttribute> attributes = stunMessage.getAttributes();
        this.putAttributes(attributes, buf);
        buf.flip();
        this.m_log.debug("Encoded STUN message as buf: {}", (Object)buf);
        return buf;
    }

    private void putAttributes(Map<StunAttributeType, StunAttribute> attributesMap, ByteBuffer buf) {
        StunAttributeEncoder visitor = new StunAttributeEncoder(buf);
        Collection<StunAttribute> attributes = attributesMap.values();
        for (StunAttribute attribute : attributes) {
            attribute.accept(visitor);
        }
    }
}

