/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message;

import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.littleshoot.stun.stack.message.AbstractStunMessage;
import org.littleshoot.stun.stack.message.StunMessageType;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.attributes.ErrorCodeAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;

public class BindingErrorResponse
extends AbstractStunMessage {
    public BindingErrorResponse(UUID transactionId, int errorCode, String reasonPhrase) {
        super(transactionId, StunMessageType.BINDING_ERROR_RESPONSE, BindingErrorResponse.createAttributes(errorCode, reasonPhrase));
    }

    public BindingErrorResponse(UUID transactionId, Map<StunAttributeType, StunAttribute> attributes) {
        super(transactionId, StunMessageType.BINDING_ERROR_RESPONSE, attributes);
    }

    private static Map<StunAttributeType, StunAttribute> createAttributes(int errorCode, String reasonPhrase) {
        ErrorCodeAttribute error = new ErrorCodeAttribute(errorCode, reasonPhrase);
        return BindingErrorResponse.createAttributes(error);
    }

    public int getErrorCode() {
        Map<StunAttributeType, StunAttribute> attributes = this.getAttributes();
        ErrorCodeAttribute errorAttribute = (ErrorCodeAttribute)attributes.get((Object)StunAttributeType.ERROR_CODE);
        return errorAttribute.getErrorCode();
    }

    @Override
    public <T> T accept(StunMessageVisitor<T> visitor) {
        return visitor.visitBindingErrorResponse(this);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " with attributes: " + this.getAttributes();
    }
}

