/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message;

import java.util.HashMap;
import java.util.Map;

public enum StunMessageType {
    BINDING_REQUEST(1),
    BINDING_SUCCESS_RESPONSE(257),
    BINDING_ERROR_RESPONSE(273),
    ALLOCATE_REQUEST(3),
    ALLOCATE_SUCCESS_RESPONSE(259),
    ALLOCATE_ERROR_RESPONSE(275),
    SEND_INDICATION(4),
    DATA_INDICATION(277),
    CONNECTION_STATUS_INDICATION(8),
    CONNECT_REQUEST(5);

    private static final Map<Integer, StunMessageType> s_intsToEnums;
    private final int m_messageType;

    private StunMessageType(int messageType) {
        this.m_messageType = messageType;
    }

    public int toInt() {
        return this.m_messageType;
    }

    public static StunMessageType toType(int typeInt) {
        return s_intsToEnums.get(new Integer(typeInt));
    }

    static {
        s_intsToEnums = new HashMap<Integer, StunMessageType>();
        for (StunMessageType type : StunMessageType.values()) {
            s_intsToEnums.put(new Integer(type.toInt()), type);
        }
    }
}

