/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.stun.stack.message.attributes;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.stun.stack.message.attributes.AddressAttributeReader;
import org.littleshoot.stun.stack.message.attributes.ErrorCodeAttribute;
import org.littleshoot.stun.stack.message.attributes.MappedAddressAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttribute;
import org.littleshoot.stun.stack.message.attributes.StunAttributeType;
import org.littleshoot.stun.stack.message.attributes.StunAttributesFactory;
import org.littleshoot.stun.stack.message.attributes.StunServerAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IceControlledAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IceControllingAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IcePriorityAttribute;
import org.littleshoot.stun.stack.message.attributes.ice.IceUseCandidateAttribute;
import org.littleshoot.stun.stack.message.attributes.turn.ConnectionStatus;
import org.littleshoot.stun.stack.message.attributes.turn.ConnectionStatusAttribute;
import org.littleshoot.stun.stack.message.attributes.turn.DataAttribute;
import org.littleshoot.stun.stack.message.attributes.turn.RelayAddressAttribute;
import org.littleshoot.stun.stack.message.attributes.turn.RemoteAddressAttribute;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunAttributesFactoryImpl
implements StunAttributesFactory {
    private final Logger LOG = LoggerFactory.getLogger(StunAttributesFactoryImpl.class);

    @Override
    public Map<StunAttributeType, StunAttribute> createAttributes(ByteBuffer body) {
        ConcurrentHashMap<StunAttributeType, StunAttribute> attributes = new ConcurrentHashMap<StunAttributeType, StunAttribute>();
        while (body.hasRemaining()) {
            this.addAttribute(attributes, body);
        }
        return attributes;
    }

    private void addAttribute(Map<StunAttributeType, StunAttribute> attributes, ByteBuffer buf) {
        int typeInt = buf.getUnsignedShort();
        StunAttributeType type = StunAttributeType.toType(typeInt);
        int length = buf.getUnsignedShort();
        if (buf.remaining() < length) {
            this.LOG.error("Error reading attribute of type: " + (Object)((Object)type) + "\nExpected length:  " + length + "\nActual remaining: " + buf.remaining());
        }
        byte[] body = new byte[length];
        buf.get(body);
        if (type == null) {
            this.LOG.debug("Did not recognize type: " + typeInt);
            return;
        }
        try {
            StunAttribute attribute = this.createAttribute(type, body);
            if (attribute != null) {
                attributes.put(type, attribute);
            }
        }
        catch (IOException e) {
            this.LOG.warn("Could not process attribute", (Throwable)e);
        }
    }

    private StunAttribute createAttribute(StunAttributeType type, byte[] bodyBytes) throws IOException {
        ByteBuffer body = ByteBuffer.wrap((byte[])bodyBytes);
        switch (type) {
            case MAPPED_ADDRESS: {
                InetSocketAddress address = AddressAttributeReader.readAddress(body);
                return new MappedAddressAttribute(address);
            }
            case SERVER: {
                String serverText = MinaUtils.toAsciiString((ByteBuffer)body);
                return new StunServerAttribute(bodyBytes.length, serverText);
            }
            case RELAY_ADDRESS: {
                InetSocketAddress address = AddressAttributeReader.readAddress(body);
                return new RelayAddressAttribute(address);
            }
            case REMOTE_ADDRESS: {
                InetSocketAddress address = AddressAttributeReader.readAddress(body);
                return new RemoteAddressAttribute(address);
            }
            case DATA: {
                return new DataAttribute(bodyBytes);
            }
            case CONNECT_STAT: {
                long statusInt = body.getUnsignedInt();
                ConnectionStatus status = ConnectionStatus.valueOf(statusInt);
                return new ConnectionStatusAttribute(status);
            }
            case ERROR_CODE: {
                this.LOG.warn("Reading error code attribute.");
                body.skip(2);
                short errorClass = body.getUnsigned();
                short errorNumber = body.getUnsigned();
                String reasonPhrase = MinaUtils.getString((ByteBuffer)body);
                return new ErrorCodeAttribute(errorClass, errorNumber, reasonPhrase);
            }
            case ICE_PRIORITY: {
                long priority = body.getUnsignedInt();
                return new IcePriorityAttribute(priority);
            }
            case ICE_USE_CANDIDATE: {
                return new IceUseCandidateAttribute();
            }
            case ICE_CONTROLLED: {
                byte[] tieBreaker = new byte[8];
                body.get(tieBreaker);
                return new IceControlledAttribute(tieBreaker);
            }
            case ICE_CONTROLLING: {
                byte[] tieBreaker = new byte[8];
                body.get(tieBreaker);
                return new IceControllingAttribute(tieBreaker);
            }
        }
        this.LOG.error("Unrecognized attribute: " + (Object)((Object)type));
        return null;
    }
}

