/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.tcp.frame;

import org.apache.commons.lang.ArrayUtils;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.util.mina.MinaUtils;

public final class TcpFrame {
    private final byte[] m_data;

    public TcpFrame(ByteBuffer data) {
        this(MinaUtils.toByteArray((ByteBuffer)data));
    }

    public TcpFrame(byte[] data) {
        if (data.length > 65535) {
            throw new IllegalArgumentException("Data length must be smaller than: 65535 but is:" + data.length);
        }
        this.m_data = (byte[])data.clone();
    }

    public TcpFrame(byte[] data, int off, int len) {
        this.m_data = ArrayUtils.subarray((byte[])data, (int)off, (int)len);
    }

    public int getLength() {
        return this.m_data.length;
    }

    public byte[] getData() {
        return (byte[])this.m_data.clone();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

