/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.tcp.frame;

import java.util.List;
import org.lastbamboo.common.tcp.frame.TcpFrame;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.util.mina.DecodingState;
import org.littleshoot.util.mina.DecodingStateMachine;
import org.littleshoot.util.mina.FixedLengthDecodingState;
import org.littleshoot.util.mina.decode.binary.UnsignedShortDecodingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpFrameDecodingState
extends DecodingStateMachine {
    private static final Logger m_log = LoggerFactory.getLogger(TcpFrameDecodingState.class);

    protected DecodingState init() throws Exception {
        m_log.debug("Initing...");
        return new ReadMessageLength();
    }

    protected void destroy() throws Exception {
    }

    protected DecodingState finishDecode(List<Object> childProducts, ProtocolDecoderOutput out) throws Exception {
        m_log.error("Got finish decode for full message");
        return null;
    }

    private static class ReadBody
    extends FixedLengthDecodingState {
        private ReadBody(int length) {
            super(length);
        }

        protected DecodingState finishDecode(ByteBuffer readData, ProtocolDecoderOutput out) throws Exception {
            if (readData.remaining() != this.m_length) {
                m_log.error("Read body of unexpected length.\nExpected length:  " + this.m_length + "\nRemaining length: " + readData.remaining());
            }
            TcpFrame message = new TcpFrame(readData);
            m_log.debug("Writing TCP Frame message to IoHandler...");
            out.write((Object)message);
            return null;
        }
    }

    private static class ReadMessageLength
    extends UnsignedShortDecodingState {
        private ReadMessageLength() {
        }

        protected DecodingState finishDecode(int length, ProtocolDecoderOutput out) throws Exception {
            m_log.debug("Read message length: " + length);
            return new ReadBody(length);
        }
    }
}

