/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.tcp.frame;

import java.io.IOException;
import org.lastbamboo.common.tcp.frame.TcpFrame;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.util.mina.AbstractIoSessionOutputStream;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TcpFrameIoSessionOutputStream
extends AbstractIoSessionOutputStream<TcpFrame> {
    private final Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private volatile long m_rawBytesWritten = 0L;

    public TcpFrameIoSessionOutputStream(IoSession session) {
        super(session);
        this.m_log.debug("Created new TCP frame output stream");
    }

    public void write(byte[] b, int off, int len) throws IOException {
        byte[] subArray = MinaUtils.toByteArray((ByteBuffer)ByteBuffer.wrap((byte[])b, (int)off, (int)len));
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("Data length is: " + subArray.length);
            this.m_rawBytesWritten += (long)subArray.length;
            this.m_log.debug("Raw bytes written: {}", (Object)this.m_rawBytesWritten);
        }
        this.write(new TcpFrame(subArray));
    }

    public void write(int b) throws IOException {
        this.m_log.warn("Wrapping single byte in TCP frame");
        byte[] bytes = new byte[1];
        this.write(new TcpFrame(bytes));
    }
}

