/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.tcp.frame;

import java.util.Collection;
import org.lastbamboo.common.tcp.frame.TcpFrame;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoHandlerAdapter;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.util.SessionUtil;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpFrameLocalIoHandler
extends IoHandlerAdapter {
    private final Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int LENGTH_LIMIT = 65435;
    private final IoSession m_ioSession;

    public TcpFrameLocalIoHandler(IoSession ioSession) {
        this.m_ioSession = ioSession;
    }

    public void messageReceived(IoSession session, Object message) {
        this.m_log.debug("Received local data message: {}", message);
        ByteBuffer in = (ByteBuffer)message;
        this.sendSplitBuffers(in);
    }

    public void messageSent(IoSession session, Object message) {
        this.m_log.debug("Sent local TURN message number: {}", (Object)session.getWrittenMessages());
    }

    public void sessionClosed(IoSession session) {
        this.m_log.debug("Received **local** session closed!!");
    }

    public void sessionCreated(IoSession session) {
        SessionUtil.initialize((IoSession)session);
        session.setIdleTime(IdleStatus.BOTH_IDLE, 600);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        session.close();
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        this.m_log.error("Error processing data for **local** session: " + session, cause);
    }

    private void sendSplitBuffers(ByteBuffer buffer) {
        Collection buffers = MinaUtils.splitToByteArrays((ByteBuffer)buffer, (int)65435);
        this.m_log.debug("Split single buffer into {}", (Object)buffers.size());
        for (byte[] data : buffers) {
            this.m_log.debug("Sending buffer with capacity: {}", (Object)data.length);
            TcpFrame frame = new TcpFrame(data);
            this.m_ioSession.write((Object)frame);
        }
    }
}

