/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.client;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lastbamboo.common.tcp.frame.TcpFrame;
import org.lastbamboo.common.tcp.frame.TcpFrameCodecFactory;
import org.lastbamboo.common.turn.client.TurnClientListener;
import org.lastbamboo.common.turn.client.TurnStunMessageMapper;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.filter.codec.ProtocolDecoder;
import org.littleshoot.mina.filter.codec.ProtocolDecoderOutput;
import org.littleshoot.stun.stack.StunDemuxableProtocolCodecFactory;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageVisitor;
import org.littleshoot.stun.stack.message.StunMessageVisitorFactory;
import org.littleshoot.util.mina.DemuxableProtocolCodecFactory;
import org.littleshoot.util.mina.DemuxingProtocolCodecFactory;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StunTcpFrameTurnClientListener
implements TurnClientListener {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final Map<InetSocketAddress, ProtocolDecoder> m_addressesToDecoders = new ConcurrentHashMap<InetSocketAddress, ProtocolDecoder>();
    private final TurnClientListener m_delegateListener;
    private final StunMessageVisitorFactory m_stunMessageVisitorFactory;
    private volatile int m_totalUnframedBytes = 0;
    private int m_totalDataBytesSentToDecode;

    public StunTcpFrameTurnClientListener(StunMessageVisitorFactory stunMessageVisitorFactory, TurnClientListener delegateListener) {
        this.m_stunMessageVisitorFactory = stunMessageVisitorFactory;
        this.m_delegateListener = delegateListener;
    }

    @Override
    public void onData(final InetSocketAddress remoteAddress, final IoSession session, byte[] data) {
        this.m_log.debug("Received data");
        ProtocolDecoderOutput out = new ProtocolDecoderOutput(){

            public void flush() {
            }

            public void write(Object message) {
                if (TcpFrame.class.isAssignableFrom(message.getClass())) {
                    TcpFrame frame = (TcpFrame)message;
                    byte[] unframed = frame.getData();
                    StunTcpFrameTurnClientListener.this.m_totalUnframedBytes += unframed.length;
                    StunTcpFrameTurnClientListener.this.m_log.debug("Unframed bytes: {}", (Object)StunTcpFrameTurnClientListener.this.m_totalUnframedBytes);
                    StunTcpFrameTurnClientListener.this.m_delegateListener.onData(remoteAddress, session, unframed);
                } else if (StunMessage.class.isAssignableFrom(message.getClass())) {
                    StunMessage sm = (StunMessage)message;
                    TurnStunMessageMapper mapper = (TurnStunMessageMapper)session.getAttribute("REMOTE_ADDRESS_MAP");
                    mapper.mapMessage(sm, remoteAddress);
                    StunMessageVisitor visitor = StunTcpFrameTurnClientListener.this.m_stunMessageVisitorFactory.createVisitor(session);
                    try {
                        sm.accept(visitor);
                    }
                    catch (Exception e) {
                        StunTcpFrameTurnClientListener.this.m_log.error("Could not process STUN message. " + message, (Throwable)e);
                    }
                } else {
                    StunTcpFrameTurnClientListener.this.m_log.error("Could not recognize data: {}", message);
                }
            }
        };
        ByteBuffer dataBuf = ByteBuffer.wrap((byte[])data);
        ProtocolDecoder decoder = this.getDecoder(remoteAddress);
        try {
            decoder.decode(session, dataBuf, out);
        }
        catch (Exception e) {
            this.m_log.warn("Error decoding data: {}", (Object)MinaUtils.toAsciiString((ByteBuffer)dataBuf), (Object)e);
        }
        this.m_totalDataBytesSentToDecode += data.length;
        this.m_log.debug("Total data bytes sent to decode: {}", (Object)this.m_totalDataBytesSentToDecode);
        this.m_log.debug("Processed data...");
    }

    private ProtocolDecoder getDecoder(InetSocketAddress remoteAddress) {
        if (this.m_addressesToDecoders.containsKey(remoteAddress)) {
            return this.m_addressesToDecoders.get(remoteAddress);
        }
        ProtocolDecoder decoder = this.newDecoder();
        this.m_addressesToDecoders.put(remoteAddress, decoder);
        return decoder;
    }

    private ProtocolDecoder newDecoder() {
        StunDemuxableProtocolCodecFactory stunCodecFactory = new StunDemuxableProtocolCodecFactory();
        TcpFrameCodecFactory tcpFramingCodecFactory = new TcpFrameCodecFactory();
        DemuxingProtocolCodecFactory dataCodecFactory = new DemuxingProtocolCodecFactory((DemuxableProtocolCodecFactory)stunCodecFactory, (DemuxableProtocolCodecFactory)tcpFramingCodecFactory);
        try {
            return dataCodecFactory.getDecoder();
        }
        catch (Exception e) {
            this.m_log.error("Could not create decoder", (Throwable)e);
            throw new RuntimeException("Could not create decoder!!", e);
        }
    }

    @Override
    public IoSession onRemoteAddressOpened(InetSocketAddress remoteAddress, IoSession ioSession) {
        return this.m_delegateListener.onRemoteAddressOpened(remoteAddress, ioSession);
    }

    @Override
    public void onRemoteAddressClosed(InetSocketAddress remoteAddress) {
        this.m_delegateListener.onRemoteAddressClosed(remoteAddress);
    }

    @Override
    public void close() {
        this.m_delegateListener.close();
    }
}

