/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.client;

import java.net.InetSocketAddress;
import java.util.Collection;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoHandlerAdapter;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.util.SessionUtil;
import org.littleshoot.stun.stack.message.turn.SendIndication;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnLocalIoHandler
extends IoHandlerAdapter {
    private final Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int LENGTH_LIMIT = 64535;
    private final InetSocketAddress m_remoteAddress;
    private final IoSession m_ioSession;

    public TurnLocalIoHandler(IoSession ioSession, InetSocketAddress remoteAddress) {
        this.m_ioSession = ioSession;
        this.m_remoteAddress = remoteAddress;
    }

    public void messageReceived(IoSession session, Object message) {
        this.m_log.debug("Received local data message.");
        ByteBuffer in = (ByteBuffer)message;
        this.sendSplitBuffers(in);
    }

    public void messageSent(IoSession session, Object message) {
        this.m_log.debug("Sent local TURN message number: {}", (Object)session.getWrittenMessages());
    }

    public void sessionClosed(IoSession session) {
        this.m_log.debug("Received **local** session closed!!");
    }

    public void sessionCreated(IoSession session) {
        SessionUtil.initialize((IoSession)session);
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        session.close();
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        this.m_log.error("Error processing data for **local** session: " + session, cause);
    }

    private void sendSplitBuffers(ByteBuffer buffer) {
        Collection buffers = MinaUtils.splitToByteArrays((ByteBuffer)buffer, (int)64535);
        this.m_log.debug("Split single buffer into {}", (Object)buffers.size());
        for (byte[] data : buffers) {
            this.m_log.debug("Sending buffer with capacity: {}", (Object)data.length);
            SendIndication indication = new SendIndication(this.m_remoteAddress, data);
            this.m_ioSession.write((Object)indication);
        }
    }
}

