/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.client;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.id.uuid.UUID;
import org.lastbamboo.common.turn.client.TurnStunMessageMapper;
import org.littleshoot.stun.stack.message.StunMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnStunMessageMapperImpl
implements TurnStunMessageMapper {
    private final Logger m_log = LoggerFactory.getLogger(this.getClass());
    private final Map<UUID, InetSocketAddress> m_transactionIdsToRemoteAddresses = Collections.synchronizedMap(new LinkedHashMap<UUID, InetSocketAddress>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 300;
        }
    });

    @Override
    public void mapMessage(StunMessage message, InetSocketAddress remoteAddress) {
        UUID id = message.getTransactionId();
        if (this.m_transactionIdsToRemoteAddresses.containsKey(id)) {
            this.m_log.debug("ID already in map for message: {}", (Object)message);
            InetSocketAddress storedAddress = this.m_transactionIdsToRemoteAddresses.get(id);
            if (!remoteAddress.equals(storedAddress)) {
                this.m_log.error("Address mappings incorrect!!\nStored:   {}\nReceived: {}", (Object)storedAddress, (Object)remoteAddress);
            }
            return;
        }
        this.m_transactionIdsToRemoteAddresses.put(id, remoteAddress);
    }

    @Override
    public InetSocketAddress get(StunMessage msg) {
        return this.m_transactionIdsToRemoteAddresses.get(msg.getTransactionId());
    }
}

