/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.server;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.SocketAddress;
import javax.management.MBeanServer;
import org.lastbamboo.common.turn.server.TcpTurnServerMBean;
import org.lastbamboo.common.turn.server.TurnClientManager;
import org.lastbamboo.common.turn.server.TurnClientManagerImpl;
import org.lastbamboo.common.turn.server.TurnServer;
import org.lastbamboo.common.turn.server.TurnServerIoHandler;
import org.lastbamboo.common.turn.server.TurnServerMessageVisitorFactory;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ByteBufferAllocator;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.SimpleByteBufferAllocator;
import org.littleshoot.mina.filter.codec.ProtocolCodecFactory;
import org.littleshoot.stun.stack.StunProtocolCodecFactory;
import org.littleshoot.util.JmxUtils;
import org.littleshoot.util.mina.MinaTcpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTurnServer
implements TurnServer,
IoServiceListener,
TcpTurnServerMBean {
    private final Logger m_log = LoggerFactory.getLogger(TcpTurnServer.class);
    private final TurnClientManager m_turnClientManager;
    private final MinaTcpServer m_minaServer;

    public TcpTurnServer() {
        this(new TurnClientManagerImpl());
    }

    public TcpTurnServer(TurnClientManager turnClientManager) {
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        this.m_turnClientManager = turnClientManager;
        StunProtocolCodecFactory codecFactory = new StunProtocolCodecFactory();
        TurnServerMessageVisitorFactory visitorFactory = new TurnServerMessageVisitorFactory(this.m_turnClientManager);
        TurnServerIoHandler handler = new TurnServerIoHandler(visitorFactory);
        this.m_minaServer = new MinaTcpServer((ProtocolCodecFactory)codecFactory, (IoServiceListener)this, (IoHandler)handler, "TCP-TURN-Server");
    }

    @Override
    public void start() throws IOException {
        this.m_minaServer.start(3478);
    }

    @Override
    public void stop() {
        this.m_log.debug("Stopping server...");
        this.m_minaServer.stop();
    }

    public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        this.m_log.debug("Started server on: {}", (Object)serviceAddress);
    }

    public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        this.m_log.warn("TURN Server deactivated on: {}", (Object)serviceAddress);
    }

    public void sessionCreated(IoSession session) {
    }

    public void sessionDestroyed(IoSession session) {
        this.m_log.debug("TURN client disconnected: " + session);
        this.m_turnClientManager.removeBinding(session);
    }

    private void startJmxServer() {
        this.m_log.debug("Starting JMX server...");
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        JmxUtils.register((MBeanServer)mbs, (Object)this.m_turnClientManager);
        JmxUtils.register((MBeanServer)mbs, (Object)this);
    }

    @Override
    public int getTurnPort() {
        return 3478;
    }
}

