/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.server;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.map.LRUMap;
import org.lastbamboo.common.turn.server.TurnClient;
import org.lastbamboo.common.turn.server.allocated.TcpAllocatedTurnServer;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.stun.stack.message.attributes.turn.ConnectionStatus;
import org.littleshoot.stun.stack.message.turn.ConnectionStatusIndication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TurnClientImpl
implements TurnClient {
    private static final Logger LOG = LoggerFactory.getLogger(TurnClientImpl.class);
    private final InetAddress m_publicAddress;
    private final InetSocketAddress m_mappedAddress;
    private final Map<InetSocketAddress, IoSession> m_connections = new ConcurrentHashMap<InetSocketAddress, IoSession>();
    private final Map<InetAddress, InetAddress> m_permittedAddresses = Collections.synchronizedMap(new LRUMap(100));
    private final Set<InetAddress> m_trackedRemoteHosts = Collections.synchronizedSet(new HashSet());
    private final IoSession m_ioSession;
    private TcpAllocatedTurnServer m_allocatedTurnServer;

    public TurnClientImpl(InetAddress publicAddress, IoSession ioSession) {
        this.m_publicAddress = publicAddress;
        this.m_ioSession = ioSession;
        this.m_mappedAddress = (InetSocketAddress)ioSession.getRemoteAddress();
    }

    @Override
    public void startServer() {
        this.m_allocatedTurnServer = new TcpAllocatedTurnServer(this, this.m_publicAddress);
        this.m_allocatedTurnServer.start();
    }

    @Override
    public boolean write(InetSocketAddress remoteAddress, ByteBuffer data) {
        IoSession session = this.m_connections.get(remoteAddress);
        if (session == null) {
            LOG.debug("Attempting to send data to host that's not there: {}", (Object)remoteAddress);
            LOG.debug("We have: {}" + this.m_connections);
            return false;
        }
        LOG.debug("Writing data using existing connection...");
        session.write((Object)data);
        return true;
    }

    @Override
    public void handleConnect(InetSocketAddress remoteAddress) {
        LOG.debug("Adding connect permission for: {} {}", (Object)remoteAddress, (Object)this);
        InetAddress address = remoteAddress.getAddress();
        this.m_permittedAddresses.put(address, address);
        this.m_trackedRemoteHosts.add(address);
        this.updateConnectionStatus(remoteAddress, ConnectionStatus.LISTEN);
    }

    @Override
    public InetSocketAddress getRelayAddress() {
        return this.m_allocatedTurnServer.getSocketAddress();
    }

    @Override
    public InetSocketAddress getMappedAddress() {
        return this.m_mappedAddress;
    }

    @Override
    public void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing client at: " + this.m_ioSession);
        }
        this.closeAllConnections();
        this.m_allocatedTurnServer.stop();
        this.m_connections.clear();
        this.m_permittedAddresses.clear();
        this.m_ioSession.close();
    }

    private void closeAllConnections() {
        Iterator<IoSession> iter = this.m_connections.values().iterator();
        while (iter.hasNext()) {
            IoSession readerWriter = iter.next();
            readerWriter.close();
            iter.remove();
        }
    }

    @Override
    public IoSession getIoSession() {
        return this.m_ioSession;
    }

    @Override
    public boolean hasActiveDestination() {
        return false;
    }

    @Override
    public void removeConnection(IoSession session) {
        LOG.debug("Removing connection to: {}", (Object)session);
        InetSocketAddress remoteAddress = (InetSocketAddress)session.getRemoteAddress();
        IoSession connection = this.m_connections.remove(remoteAddress);
        if (connection != null) {
            connection.close();
            this.updateConnectionStatus(remoteAddress, ConnectionStatus.CLOSED);
        } else {
            LOG.warn("Asked to remove connection we don't know about:\n" + session + " not in:\n" + this.m_connections);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Number of connections after removal: " + this.m_connections.size());
        }
    }

    @Override
    public void addConnection(IoSession session) {
        InetSocketAddress socketAddress = (InetSocketAddress)session.getRemoteAddress();
        this.m_connections.put(socketAddress, session);
        this.updateConnectionStatus(socketAddress, ConnectionStatus.ESTABLISHED);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Now " + this.m_connections.size() + " connection(s)...");
        }
    }

    private void updateConnectionStatus(InetSocketAddress remoteAddress, ConnectionStatus status) {
        LOG.debug("Writing connection status indication...");
        ConnectionStatusIndication indication = new ConnectionStatusIndication(remoteAddress, status);
        this.m_ioSession.write((Object)indication);
    }

    @Override
    public boolean hasIncomingPermission(IoSession session) {
        LOG.debug("Checking permissions for: {}", (Object)session);
        InetSocketAddress socketAddress = (InetSocketAddress)session.getRemoteAddress();
        boolean hasPermission = this.m_trackedRemoteHosts.contains(socketAddress.getAddress());
        LOG.debug("{} returning permission: {}", (Object)this, (Object)new Boolean(hasPermission));
        return hasPermission;
    }

    @Override
    public int getNumConnections() {
        return this.m_connections.size();
    }
}

