/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.server;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lastbamboo.common.amazon.ec2.AmazonEc2Utils;
import org.lastbamboo.common.turn.server.TurnClient;
import org.lastbamboo.common.turn.server.TurnClientImpl;
import org.lastbamboo.common.turn.server.TurnClientManager;
import org.lastbamboo.common.turn.server.TurnClientManagerImplMBean;
import org.littleshoot.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TurnClientManagerImpl
implements TurnClientManager,
TurnClientManagerImplMBean {
    private final Logger m_log = LoggerFactory.getLogger(TurnClientManagerImpl.class);
    private final Map<IoSession, TurnClient> m_clientMappings = new ConcurrentHashMap<IoSession, TurnClient>();
    private final InetAddress m_publicAddress = AmazonEc2Utils.getPublicAddress();
    private int m_maxSize = 0;
    private int m_maxRemotePerClient = 0;
    private int m_maxRemoteClients;

    @Override
    public TurnClient allocateBinding(IoSession ioSession) {
        if (this.m_clientMappings.containsKey(ioSession)) {
            this.m_log.debug("Keep alive -- we already have the binding");
            return this.m_clientMappings.get(ioSession);
        }
        TurnClientImpl turnClient = new TurnClientImpl(this.m_publicAddress, ioSession);
        turnClient.startServer();
        this.m_clientMappings.put(ioSession, turnClient);
        if (this.m_clientMappings.size() > this.m_maxSize) {
            this.m_maxSize = this.m_clientMappings.size();
        }
        return turnClient;
    }

    @Override
    public TurnClient getTurnClient(IoSession readerWriter) {
        return this.m_clientMappings.get(readerWriter);
    }

    @Override
    public TurnClient removeBinding(IoSession session) {
        TurnClient client;
        if (this.m_log.isDebugEnabled()) {
            this.m_log.debug("Removing binding for: " + session);
        }
        if ((client = this.m_clientMappings.remove(session)) != null) {
            client.close();
        }
        return client;
    }

    @Override
    public int getNumTurnClients() {
        return this.m_clientMappings.size();
    }

    @Override
    public int getMaxNumTurnClients() {
        return this.m_maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumRemoteTurnClients() {
        int numRemoteClients = 0;
        Map<IoSession, TurnClient> map = this.m_clientMappings;
        synchronized (map) {
            Collection<TurnClient> clients = this.m_clientMappings.values();
            for (TurnClient client : clients) {
                int numRemote = client.getNumConnections();
                if (numRemote > this.m_maxRemotePerClient) {
                    this.m_maxRemotePerClient = numRemote;
                }
                numRemoteClients += numRemote;
            }
        }
        if (numRemoteClients > this.m_maxRemoteClients) {
            this.m_maxRemoteClients = numRemoteClients;
        }
        return numRemoteClients;
    }

    @Override
    public int getMaxNumRemoteTurnClients() {
        return this.m_maxRemoteClients;
    }

    @Override
    public int getMaxNumRemoteSingleTurnClient() {
        return this.m_maxRemotePerClient;
    }
}

