/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.server;

import java.io.IOException;
import org.lastbamboo.common.turn.server.TcpTurnServer;
import org.lastbamboo.common.turn.server.TurnClientManagerImpl;
import org.lastbamboo.common.turn.server.TurnServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(TurnLauncher.class);
    private TurnServer m_turnServer = new TcpTurnServer(new TurnClientManagerImpl());

    public static void main(String[] args) {
        LOG.debug("Launching SIP and TURN servers...");
        TurnLauncher launcher = new TurnLauncher();
        LOG.debug("Created launcher");
        try {
            launcher.start();
            LOG.debug("Started launcher");
        }
        catch (Throwable t) {
            LOG.error("Could not start!!!", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        this.m_turnServer.start();
        try {
            TurnLauncher turnLauncher = this;
            synchronized (turnLauncher) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            LOG.debug("Got interrupt -- CTR-Ced?", (Throwable)e);
        }
    }

    public void stop() {
        this.m_turnServer.stop();
    }
}

