/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.server;

import java.net.InetSocketAddress;
import org.lastbamboo.common.turn.server.TurnClient;
import org.lastbamboo.common.turn.server.TurnClientManager;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.stun.stack.message.StunMessage;
import org.littleshoot.stun.stack.message.StunMessageVisitorAdapter;
import org.littleshoot.stun.stack.message.turn.AllocateRequest;
import org.littleshoot.stun.stack.message.turn.AllocateSuccessResponse;
import org.littleshoot.stun.stack.message.turn.ConnectRequest;
import org.littleshoot.stun.stack.message.turn.SendIndication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TurnServerMessageVisitor
extends StunMessageVisitorAdapter<StunMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(TurnServerMessageVisitor.class);
    private final TurnClientManager m_turnClientManager;
    private final IoSession m_ioSession;

    public TurnServerMessageVisitor(IoSession ioSession, TurnClientManager clientManager) {
        this.m_ioSession = ioSession;
        this.m_turnClientManager = clientManager;
    }

    public StunMessage visitAllocateRequest(AllocateRequest request) {
        LOG.debug("Processing allocate request...");
        TurnClient client = this.m_turnClientManager.allocateBinding(this.m_ioSession);
        InetSocketAddress relayAddress = client.getRelayAddress();
        InetSocketAddress mappedAddress = client.getMappedAddress();
        AllocateSuccessResponse response = new AllocateSuccessResponse(request.getTransactionId(), relayAddress, mappedAddress);
        this.m_ioSession.write((Object)response);
        return null;
    }

    public StunMessage visitSendIndication(SendIndication indication) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing Send Indication with body length: " + indication.getBodyLength());
        }
        InetSocketAddress remoteAddress = indication.getRemoteAddress();
        byte[] data = indication.getData();
        TurnClient client = this.m_turnClientManager.getTurnClient(this.m_ioSession);
        client.write(remoteAddress, ByteBuffer.wrap((byte[])data));
        LOG.trace("Finished handling Send Indication...");
        return null;
    }

    public StunMessage visitConnectRequest(ConnectRequest request) {
        LOG.debug("Processing connect request for: {}", (Object)request.getRemoteAddress());
        InetSocketAddress remoteAddress = request.getRemoteAddress();
        TurnClient client = this.m_turnClientManager.getTurnClient(this.m_ioSession);
        client.handleConnect(remoteAddress);
        return null;
    }
}

