/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.server.allocated;

import org.lastbamboo.common.turn.server.TurnClient;
import org.littleshoot.mina.common.IdleStatus;
import org.littleshoot.mina.common.IoHandlerAdapter;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.util.SessionUtil;
import org.littleshoot.stun.stack.message.turn.DataIndication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocatedTurnServerIoHandler
extends IoHandlerAdapter {
    private final Logger m_log = LoggerFactory.getLogger(AllocatedTurnServerIoHandler.class);
    private final TurnClient m_turnClient;

    public AllocatedTurnServerIoHandler(TurnClient client) {
        this.m_turnClient = client;
    }

    public void messageReceived(IoSession session, Object message) {
        this.m_log.debug("Received message on allocated server: {}", message);
        this.m_log.debug("Now sent " + session.getWrittenMessages());
        DataIndication indication = (DataIndication)message;
        this.m_turnClient.getIoSession().write((Object)indication);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        this.m_log.warn("Exception on allocated TURN IoHandler", cause);
        session.close();
    }

    public void sessionCreated(IoSession session) throws Exception {
        SessionUtil.initialize((IoSession)session);
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        this.m_log.debug("Got idle TURN session");
    }
}

