/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.server.allocated;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.lastbamboo.common.turn.server.TurnClient;
import org.lastbamboo.common.turn.server.allocated.AllocatedTurnServer;
import org.lastbamboo.common.turn.server.allocated.AllocatedTurnServerIoHandler;
import org.lastbamboo.common.turn.server.allocated.TurnRawDataFilter;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.ByteBufferAllocator;
import org.littleshoot.mina.common.DefaultIoFilterChainBuilder;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoHandler;
import org.littleshoot.mina.common.IoService;
import org.littleshoot.mina.common.IoServiceConfig;
import org.littleshoot.mina.common.IoServiceListener;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.mina.common.SimpleByteBufferAllocator;
import org.littleshoot.mina.common.ThreadModel;
import org.littleshoot.mina.filter.executor.ExecutorFilter;
import org.littleshoot.mina.transport.socket.nio.SocketAcceptor;
import org.littleshoot.mina.transport.socket.nio.SocketAcceptorConfig;
import org.littleshoot.util.DaemonThreadFactory;
import org.littleshoot.util.NetworkUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpAllocatedTurnServer
implements AllocatedTurnServer,
IoServiceListener {
    private final Logger LOG = LoggerFactory.getLogger(TcpAllocatedTurnServer.class);
    private final TurnClient m_turnClient;
    private final SocketAcceptor m_acceptor;
    private final InetAddress m_publicAddress;
    private InetSocketAddress m_serviceAddress;
    private final Executor m_threadPool = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory("TCP-Allocated-TURN-Server-Thread-Pool"));

    public TcpAllocatedTurnServer(TurnClient turnClient, InetAddress publicAddress) {
        this.m_turnClient = turnClient;
        this.m_publicAddress = publicAddress;
        ByteBuffer.setUseDirectBuffers((boolean)false);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        this.m_acceptor = new SocketAcceptor(4, this.m_threadPool);
        this.m_acceptor.addListener((IoServiceListener)this);
    }

    @Override
    public void start() {
        SocketAcceptorConfig config = this.m_acceptor.getDefaultConfig();
        config.setThreadModel(ThreadModel.MANUAL);
        DefaultIoFilterChainBuilder filterChainBuilder = this.m_acceptor.getDefaultConfig().getFilterChain();
        filterChainBuilder.addLast("to-stun", (IoFilter)new TurnRawDataFilter());
        filterChainBuilder.addLast("threadPool", (IoFilter)new ExecutorFilter(this.m_threadPool));
        AllocatedTurnServerIoHandler handler = new AllocatedTurnServerIoHandler(this.m_turnClient);
        try {
            InetSocketAddress bindAddress = new InetSocketAddress(NetworkUtils.getLocalHost(), 0);
            this.m_acceptor.bind((SocketAddress)bindAddress, (IoHandler)handler);
            this.LOG.debug("Started TCP allocated TURN server, bound to: " + bindAddress);
        }
        catch (IOException e) {
            this.LOG.error("Could not bind server", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        this.m_acceptor.unbindAll();
    }

    public void serviceActivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        InetSocketAddress isa = (InetSocketAddress)serviceAddress;
        this.m_serviceAddress = new InetSocketAddress(this.m_publicAddress, isa.getPort());
        this.LOG.debug("Allocated server started on: {}", (Object)serviceAddress);
        this.LOG.debug("Using public address: {}", (Object)this.m_serviceAddress);
    }

    public void serviceDeactivated(IoService service, SocketAddress serviceAddress, IoHandler handler, IoServiceConfig config) {
        this.LOG.debug("Deactivating allocated TURN server...");
    }

    public void sessionCreated(IoSession session) {
        this.m_turnClient.addConnection(session);
    }

    public void sessionDestroyed(IoSession session) {
        this.LOG.debug("Lost connection to: {}", (Object)session);
        this.m_turnClient.removeConnection(session);
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return this.m_serviceAddress;
    }
}

