/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.turn.server.allocated;

import java.net.InetSocketAddress;
import java.util.Collection;
import org.littleshoot.mina.common.ByteBuffer;
import org.littleshoot.mina.common.IoFilter;
import org.littleshoot.mina.common.IoFilterAdapter;
import org.littleshoot.mina.common.IoSession;
import org.littleshoot.stun.stack.message.turn.DataIndication;
import org.littleshoot.util.mina.MinaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnRawDataFilter
extends IoFilterAdapter {
    private final Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int LENGTH_LIMIT = 64535;

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        this.m_log.debug("Received raw data...");
        InetSocketAddress remoteHost = (InetSocketAddress)session.getRemoteAddress();
        ByteBuffer in = (ByteBuffer)message;
        this.sendSplitBuffers(remoteHost, in, session, nextFilter);
    }

    private void sendSplitBuffers(InetSocketAddress remoteHost, ByteBuffer buffer, IoSession session, IoFilter.NextFilter nextFilter) {
        Collection buffers = MinaUtils.splitToByteArrays((ByteBuffer)buffer, (int)64535);
        for (byte[] data : buffers) {
            DataIndication indication = new DataIndication(remoteHost, data);
            nextFilter.messageReceived(session, (Object)indication);
        }
    }
}

