/*
 * Decompiled with CFR 0.152.
 */
package udt;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import udt.CongestionControl;
import udt.UDTSession;
import udt.util.UDTStatistics;
import udt.util.Util;

public class UDTCongestionControl
implements CongestionControl {
    private static final Logger logger = Logger.getLogger(UDTCongestionControl.class.getName());
    protected final UDTSession session;
    protected final UDTStatistics statistics;
    protected long roundTripTime = 0L;
    protected long packetArrivalRate = 0L;
    protected long estimatedLinkCapacity = 0L;
    protected double packetSendingPeriod = 1.0;
    protected double congestionWindowSize = 16.0;
    private boolean slowStartPhase = true;
    private long lastAckSeqNumber = -1L;
    private long lastDecreaseSeqNo;
    private long nACKCount = 1L;
    long decCount = 1L;
    long decreaseRandom = 1L;
    long averageNACKNum;
    private boolean loss = false;
    protected long ackInterval = -1L;
    private final long PS = 1500L;
    private final double BetaDivPS = 1.0E-9;

    public UDTCongestionControl(UDTSession session) {
        this.session = session;
        this.statistics = session.getStatistics();
        this.lastDecreaseSeqNo = session.getInitialSequenceNumber() - 1L;
    }

    @Override
    public void init() {
    }

    @Override
    public void setRTT(long rtt, long rttVar) {
        this.roundTripTime = rtt;
    }

    @Override
    public void updatePacketArrivalRate(long rate, long linkCapacity) {
        this.packetArrivalRate = this.packetArrivalRate > 0L ? (this.packetArrivalRate * 7L + rate) / 8L : rate;
        this.estimatedLinkCapacity = this.estimatedLinkCapacity > 0L ? (this.estimatedLinkCapacity * 7L + linkCapacity) / 8L : linkCapacity;
    }

    @Override
    public long getPacketArrivalRate() {
        return this.packetArrivalRate;
    }

    @Override
    public long getEstimatedLinkCapacity() {
        return this.estimatedLinkCapacity;
    }

    @Override
    public double getSendInterval() {
        return this.packetSendingPeriod;
    }

    @Override
    public long getAckInterval() {
        return this.ackInterval;
    }

    @Override
    public void setAckInterval(long ackInterval) {
        this.ackInterval = ackInterval;
        if (this.session.getSocket() != null && this.session.getSocket().getReceiver() != null) {
            this.session.getSocket().getReceiver().setAckInterval(ackInterval);
        }
    }

    @Override
    public double getCongestionWindowSize() {
        return this.congestionWindowSize;
    }

    @Override
    public void onACK(long ackSeqno) {
        if (this.slowStartPhase) {
            this.congestionWindowSize += (double)(ackSeqno - this.lastAckSeqNumber);
            this.lastAckSeqNumber = ackSeqno;
            if (this.congestionWindowSize > (double)this.session.getFlowWindowSize()) {
                this.slowStartPhase = false;
                this.packetSendingPeriod = this.packetArrivalRate > 0L ? 1000000.0 / (double)this.packetArrivalRate : this.congestionWindowSize / ((double)this.roundTripTime + Util.getSYNTimeD());
            }
        } else {
            double A = (double)this.packetArrivalRate / 1000000.0 * ((double)this.roundTripTime + Util.getSYNTimeD());
            this.congestionWindowSize = (long)A + 16L;
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("receive rate " + this.packetArrivalRate + " rtt " + this.roundTripTime + " set to window size: " + (A + 16.0));
            }
        }
        if (this.slowStartPhase) {
            return;
        }
        if (this.loss) {
            this.loss = false;
            return;
        }
        double numOfIncreasingPacket = this.computeNumOfIncreasingPacket();
        double factor = Util.getSYNTimeD() / (this.packetSendingPeriod * numOfIncreasingPacket + Util.getSYNTimeD());
        this.packetSendingPeriod = factor * this.packetSendingPeriod;
        this.statistics.setSendPeriod(this.packetSendingPeriod);
    }

    private double computeNumOfIncreasingPacket() {
        double remaining = (double)this.estimatedLinkCapacity - 1000000.0 / this.packetSendingPeriod;
        if (remaining <= 0.0) {
            return 6.666666666666666E-4;
        }
        double exp = Math.ceil(Math.log10(remaining * 1500.0 * 8.0));
        double power10 = Math.pow(10.0, exp) * 1.0E-9;
        return Math.max(power10, 0.0);
    }

    @Override
    public void onLoss(List<Integer> lossInfo) {
        this.loss = true;
        long firstBiggestlossSeqNo = lossInfo.get(0).intValue();
        ++this.nACKCount;
        if (this.slowStartPhase) {
            this.packetSendingPeriod = this.packetArrivalRate > 0L ? 100000.0 / (double)this.packetArrivalRate : this.congestionWindowSize / (double)(this.roundTripTime + Util.getSYNTime());
            this.slowStartPhase = false;
            return;
        }
        long currentMaxSequenceNumber = this.session.getSocket().getSender().getCurrentSequenceNumber();
        if (firstBiggestlossSeqNo > this.lastDecreaseSeqNo) {
            this.packetSendingPeriod = Math.ceil(this.packetSendingPeriod * 1.125);
            this.averageNACKNum = (int)Math.ceil((double)this.averageNACKNum * 0.875 + (double)this.nACKCount * 0.125);
            this.nACKCount = 1L;
            this.decCount = 1L;
            this.decreaseRandom = (int)Math.ceil((double)(this.averageNACKNum - 1L) * Math.random() + 1.0);
            this.lastDecreaseSeqNo = currentMaxSequenceNumber;
        } else if (this.decCount <= 5L && this.nACKCount == this.decCount * this.decreaseRandom) {
            this.packetSendingPeriod = Math.ceil(this.packetSendingPeriod * 1.125);
            ++this.decCount;
            this.lastDecreaseSeqNo = currentMaxSequenceNumber;
        }
        this.statistics.setSendPeriod(this.packetSendingPeriod);
    }

    @Override
    public void onTimeout() {
    }

    @Override
    public void onPacketSend(long packetSeqNo) {
    }

    @Override
    public void onPacketReceive(long packetSeqNo) {
    }

    @Override
    public void close() {
    }
}

