/*
 * Decompiled with CFR 0.152.
 */
package udt;

import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import udt.UDTSocket;

public class UDTOutputStream
extends OutputStream {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final UDTSocket socket;
    private volatile boolean closed;

    public UDTOutputStream(UDTSocket socket) {
        this.socket = socket;
    }

    @Override
    public void write(int args) throws IOException {
        this.log.info("Writing single byte");
        this.checkClosed();
        this.socket.doWrite(new byte[]{(byte)args});
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.log.info("Writing data with offset '" + off + "' and len '" + len + "'");
        this.checkClosed();
        this.socket.doWrite(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.log.info("Writing straight byte array");
        this.write(b, 0, b.length);
    }

    @Override
    public void flush() throws IOException {
        this.log.info("Flushing -- IGNORING!!");
    }

    public void pauseOutput() throws IOException {
        this.log.info("Pausing output");
        this.socket.getSender().pause();
    }

    @Override
    public void close() throws IOException {
        this.log.info("Closing output stream");
        this.closed = true;
    }

    private void checkClosed() throws IOException {
        this.log.info("Checking closed");
        if (this.closed) {
            this.log.info("OutputStream is closed!!");
            throw new IOException("Stream has been closed");
        }
    }
}

