/*
 * Decompiled with CFR 0.152.
 */
package udt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import udt.UDPEndPoint;
import udt.UDTInputStream;
import udt.UDTOutputStream;
import udt.UDTReceiver;
import udt.UDTSender;
import udt.UDTSession;
import udt.packets.DataPacket;
import udt.packets.Shutdown;

public class UDTSocket
extends Socket {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final UDPEndPoint endpoint;
    private volatile boolean active;
    private UDTReceiver receiver;
    private UDTSender sender;
    private final UDTSession session;
    private UDTInputStream inputStream;
    private UDTOutputStream outputStream;

    public UDTSocket(UDPEndPoint endpoint, UDTSession session) throws SocketException {
        this.endpoint = endpoint;
        this.session = session;
        this.receiver = new UDTReceiver(session, endpoint);
        this.sender = new UDTSender(session, endpoint);
    }

    public UDTReceiver getReceiver() {
        return this.receiver;
    }

    public void setReceiver(UDTReceiver receiver) {
        this.receiver = receiver;
    }

    public UDTSender getSender() {
        return this.sender;
    }

    public void setSender(UDTSender sender) {
        this.sender = sender;
    }

    public boolean isActive() {
        return this.active;
    }

    public UDPEndPoint getEndpoint() {
        return this.endpoint;
    }

    public final UDTSession getSession() {
        return this.session;
    }

    protected void doWrite(byte[] data) throws IOException {
        this.logger.info("Called...");
        this.doWrite(data, 0, data.length);
    }

    protected void doWrite(byte[] data, int offset, int length) throws IOException {
        this.logger.info("Called...");
        try {
            this.doWrite(data, offset, length, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ie) {
            IOException io = new IOException();
            io.initCause(ie);
            throw io;
        }
    }

    protected void doWrite(byte[] data, int offset, int length, int timeout, TimeUnit units) throws IOException, InterruptedException {
        this.logger.info("Got call to write data!!!: ");
        int chunksize = this.session.getDatagramSize() - 24;
        ByteBuffer bb = ByteBuffer.wrap(data, offset, length);
        long seqNo = 0L;
        while (bb.remaining() > 0) {
            int len = Math.min(bb.remaining(), chunksize);
            byte[] chunk = new byte[len];
            bb.get(chunk);
            DataPacket packet = new DataPacket();
            seqNo = this.sender.getNextSequenceNumber();
            packet.setPacketSequenceNumber(seqNo);
            packet.setSession(this.session);
            packet.setDestinationID(this.session.getDestination().getSocketID());
            packet.setData(chunk);
            if (this.sender.sendUdtPacket(packet, timeout, units)) continue;
            this.logger.warn("Queue full!!");
            throw new IOException("Queue full");
        }
        if (length > 0) {
            this.active = true;
        }
    }

    protected void flush() throws InterruptedException {
        this.logger.info("Flushing...");
        if (!this.active) {
            this.logger.info("Not active...returning from flush call");
            return;
        }
        long seqNo = this.sender.getCurrentSequenceNumber();
        if (seqNo < 0L) {
            this.logger.info("Sequence number less than zero??!!");
            throw new IllegalStateException();
        }
        this.logger.info("Flushing...checking for sent out...");
        while (!this.sender.isSentOut(seqNo)) {
            Thread.sleep(5L);
        }
        if (seqNo > -1L) {
            this.logger.info("Flushing...waiting for ack...");
            while (this.active && !this.sender.haveAcknowledgementFor(seqNo)) {
                this.sender.waitForAck(seqNo);
            }
        }
        this.logger.info("Flushing...pausing");
        this.sender.pause();
        this.logger.info("Flushing...returning");
    }

    protected void doWriteBlocking(byte[] data) throws IOException, InterruptedException {
        this.logger.info("Called...");
        this.doWrite(data);
        this.flush();
    }

    @Override
    public void bind(SocketAddress address) throws IOException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void close() throws IOException {
        this.logger.info("Called...");
        this.active = false;
        Shutdown shutdown = new Shutdown();
        shutdown.setDestinationID(this.session.getDestination().getSocketID());
        shutdown.setSession(this.session);
        try {
            this.endpoint.doSend(shutdown);
        }
        catch (IOException e) {
            this.logger.error("Exception shutting down", (Throwable)e);
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            this.logger.error("Sleep interrupted?", (Throwable)e);
        }
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
        this.receiver.stop();
        this.sender.stop();
        this.endpoint.stop();
    }

    @Override
    public void connect(SocketAddress address) throws IOException {
        this.logger.info("Called");
        this.connect(address, 60000);
    }

    @Override
    public void connect(SocketAddress address, int timeout) throws IOException {
        this.logger.info("Called");
    }

    @Override
    public SocketChannel getChannel() {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public InetAddress getInetAddress() {
        this.logger.info("Called");
        return this.endpoint.getSocket().getInetAddress();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.logger.info("Getting input stream");
        if (this.inputStream == null) {
            this.inputStream = new UDTInputStream(this);
        }
        return this.inputStream;
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        this.logger.info("Called");
        return false;
    }

    @Override
    public InetAddress getLocalAddress() {
        this.logger.info("Called");
        return this.endpoint.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        this.logger.info("Called");
        return this.endpoint.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        this.logger.info("Called");
        return this.endpoint.getSocket().getLocalSocketAddress();
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        this.logger.info("Called");
        return false;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.logger.info("Getting output stream");
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        if (this.outputStream == null) {
            this.outputStream = new UDTOutputStream(this);
        }
        return this.outputStream;
    }

    @Override
    public int getPort() {
        this.logger.info("Getting port");
        return this.endpoint.getSocket().getPort();
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        this.logger.info("Called");
        return 81660;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        this.logger.info("Called");
        return this.endpoint.getSocket().getRemoteSocketAddress();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        this.logger.info("Called");
        return 81660;
    }

    @Override
    public int getSoLinger() throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBound() {
        this.logger.info("Called");
        return this.endpoint.getSocket().isBound();
    }

    @Override
    public boolean isClosed() {
        this.logger.info("Called -- returning--" + !this.active);
        return false;
    }

    @Override
    public boolean isConnected() {
        this.logger.info("Called");
        int state = this.session.getState();
        return state == 2 || state == 3;
    }

    @Override
    public boolean isInputShutdown() {
        this.logger.info("Called");
        return this.isClosed();
    }

    @Override
    public boolean isOutputShutdown() {
        this.logger.info("Called");
        return this.isClosed();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.logger.info("Called");
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout can't be negative");
        }
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.logger.info("Called");
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.logger.warn("Not supported!!!");
        throw new UnsupportedOperationException();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.logger.info("Called");
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.logger.info("Called");
    }
}

