/*
 * Decompiled with CFR 0.152.
 */
package udt.packets;

import java.io.ByteArrayOutputStream;
import udt.packets.ControlPacket;
import udt.packets.PacketUtil;

public class Acknowledgement
extends ControlPacket {
    private long ackNumber;
    private long roundTripTime;
    private long roundTripTimeVariance;
    private long bufferSize;
    private long pktArrivalSpeed;
    private long estimatedLinkCapacity;

    public Acknowledgement() {
        this.controlPacketType = ControlPacket.ControlPacketType.ACK.ordinal();
    }

    public Acknowledgement(byte[] controlInformation) {
        this();
        this.decodeControlInformation(controlInformation);
    }

    void decodeControlInformation(byte[] data) {
        this.ackNumber = PacketUtil.decode(data, 0);
        this.roundTripTime = PacketUtil.decode(data, 4);
        this.roundTripTimeVariance = PacketUtil.decode(data, 8);
        this.bufferSize = PacketUtil.decode(data, 12);
        this.pktArrivalSpeed = PacketUtil.decode(data, 16);
        this.estimatedLinkCapacity = PacketUtil.decode(data, 20);
    }

    public long getAckNumber() {
        return this.ackNumber;
    }

    public void setNexttoPrevPktSeqNO(long nexttoPrevPktSeqNO) {
        this.ackNumber = nexttoPrevPktSeqNO;
    }

    public long getRoundTripTime() {
        return this.roundTripTime;
    }

    public void setRoundTripTime(long RoundTripTime) {
        this.roundTripTime = RoundTripTime;
    }

    public void setRoundTripTimeVar(long roundTripTimeVar) {
        this.roundTripTimeVariance = roundTripTimeVar;
    }

    public long getRoundTripTimeVar() {
        return this.roundTripTimeVariance;
    }

    public long getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(long bufferSiZe) {
        this.bufferSize = bufferSiZe;
    }

    public long getPacketReceiveRate() {
        return this.pktArrivalSpeed;
    }

    public void setPacketReceiveRate(long packetReceiveRate) {
        this.pktArrivalSpeed = packetReceiveRate;
    }

    public long getEstimatedLinkCapacity() {
        return this.estimatedLinkCapacity;
    }

    public void setEstimatedLinkCapacity(long estimatedLinkCapacity) {
        this.estimatedLinkCapacity = estimatedLinkCapacity;
    }

    @Override
    public byte[] encodeControlInformation() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(PacketUtil.encode(this.ackNumber));
            bos.write(PacketUtil.encode(this.roundTripTime));
            bos.write(PacketUtil.encode(this.roundTripTimeVariance));
            bos.write(PacketUtil.encode(this.bufferSize));
            bos.write(PacketUtil.encode(this.pktArrivalSpeed));
            bos.write(PacketUtil.encode(this.estimatedLinkCapacity));
            return bos.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Acknowledgement other = (Acknowledgement)obj;
        if (this.ackNumber != other.ackNumber) {
            return false;
        }
        if (this.roundTripTime != other.roundTripTime) {
            return false;
        }
        if (this.roundTripTimeVariance != other.roundTripTimeVariance) {
            return false;
        }
        if (this.bufferSize != other.bufferSize) {
            return false;
        }
        if (this.estimatedLinkCapacity != other.estimatedLinkCapacity) {
            return false;
        }
        return this.pktArrivalSpeed == other.pktArrivalSpeed;
    }
}

