/*
 * Decompiled with CFR 0.152.
 */
package udt.packets;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import udt.UDTPacket;
import udt.UDTSession;
import udt.packets.PacketUtil;

public abstract class ControlPacket
implements UDTPacket {
    protected int controlPacketType;
    protected long ackSequenceNumber;
    protected long messageNumber;
    protected long timeStamp;
    protected long destinationID;
    protected byte[] controlInformation;
    private UDTSession session;

    @Override
    public int getControlPacketType() {
        return this.controlPacketType;
    }

    public long getAckSequenceNumber() {
        return this.ackSequenceNumber;
    }

    public void setAckSequenceNumber(long ackSequenceNumber) {
        this.ackSequenceNumber = ackSequenceNumber;
    }

    @Override
    public long getMessageNumber() {
        return this.messageNumber;
    }

    @Override
    public void setMessageNumber(long messageNumber) {
        this.messageNumber = messageNumber;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public long getDestinationID() {
        return this.destinationID;
    }

    @Override
    public void setDestinationID(long destinationID) {
        this.destinationID = destinationID;
    }

    @Override
    public byte[] getHeader() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(16);
            bos.write(PacketUtil.encodeHighesBitTypeAndSeqNumber(true, this.controlPacketType, this.ackSequenceNumber));
            bos.write(PacketUtil.encode(this.messageNumber));
            bos.write(PacketUtil.encode(this.timeStamp));
            bos.write(PacketUtil.encode(this.destinationID));
            return bos.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public abstract byte[] encodeControlInformation();

    @Override
    public byte[] getEncoded() {
        byte[] header = this.getHeader();
        byte[] controlInfo = this.encodeControlInformation();
        byte[] result = controlInfo != null ? new byte[header.length + controlInfo.length] : new byte[header.length];
        System.arraycopy(header, 0, result, 0, header.length);
        if (controlInfo != null) {
            System.arraycopy(controlInfo, 0, result, header.length, controlInfo.length);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ControlPacket other = (ControlPacket)obj;
        if (this.ackSequenceNumber != other.ackSequenceNumber) {
            return false;
        }
        if (this.controlPacketType != other.controlPacketType) {
            return false;
        }
        if (this.destinationID != other.destinationID) {
            return false;
        }
        if (this.messageNumber != other.messageNumber) {
            return false;
        }
        return this.timeStamp == other.timeStamp;
    }

    @Override
    public boolean isControlPacket() {
        return true;
    }

    @Override
    public boolean forSender() {
        return true;
    }

    @Override
    public boolean isConnectionHandshake() {
        return false;
    }

    @Override
    public UDTSession getSession() {
        return this.session;
    }

    public void setSession(UDTSession session) {
        this.session = session;
    }

    @Override
    public long getPacketSequenceNumber() {
        return -1L;
    }

    @Override
    public int compareTo(UDTPacket other) {
        return (int)(this.getPacketSequenceNumber() - other.getPacketSequenceNumber());
    }

    public static enum ControlPacketType {
        CONNECTION_HANDSHAKE,
        KEEP_ALIVE,
        ACK,
        NAK,
        UNUNSED_1,
        SHUTDOWN,
        ACK2,
        MESSAGE_DROP_REQUEST,
        UNUNSED_2,
        UNUNSED_3,
        UNUNSED_4,
        UNUNSED_5,
        UNUNSED_6,
        UNUNSED_7,
        UNUNSED_8,
        USER_DEFINED;

    }
}

